/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.testwise_coverage;

import com.teamscale.commons.utils.StringPool;
import com.teamscale.index.report.coverage.testwise_coverage.TestInfoContainerBuilder;
import com.teamscale.index.report.coverage.testwise_coverage.TestWiseCoveragePathMatchingPlausibilityCheck;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.CoverageUnitContainer;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestInfoContainer;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.ExecutionUnitInfo;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.FileInfo;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestInfo;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestwiseCoverageReport;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TestInfoContainerBuilderV2
implements TestInfoContainerBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CoverageInfoRetriever coverageInfoRetriever;
    private final IMatchingPathsLookup matchingPathsLookup;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private final boolean disablePlausibilityCheckForPathMapping;

    public TestInfoContainerBuilderV2(CoverageInfoRetriever coverageInfoRetriever, IMatchingPathsLookup matchingPathsLookup, TokenElementLineInfoIndex tokenElementLineInfoIndex, boolean disablePlausibilityCheckForPathMapping) {
        this.coverageInfoRetriever = coverageInfoRetriever;
        this.matchingPathsLookup = matchingPathsLookup;
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.disablePlausibilityCheckForPathMapping = disablePlausibilityCheckForPathMapping;
    }

    @Override
    public void build(TestwiseCoverageReport testwiseCoverageReport) throws StorageException, ReportParserException {
        for (TestInfo test : testwiseCoverageReport.tests) {
            try {
                this.constructTestInfoContainer(test, testwiseCoverageReport.files, testwiseCoverageReport.isPartial(), null);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Dropping coverage for " + test.uniformPath + " due to error: ", (Throwable)ex);
            }
        }
        for (ExecutionUnitInfo executionUnitInfo : testwiseCoverageReport.executionUnits) {
            ExecutionUnit executionUnit = this.constructExecutionUnitContainer(executionUnitInfo, testwiseCoverageReport.files, testwiseCoverageReport.isPartial());
            for (TestInfo test : executionUnitInfo.getTests()) {
                try {
                    TestInfoContainer testInfoContainer = this.constructTestInfoContainer(test, testwiseCoverageReport.files, testwiseCoverageReport.isPartial(), executionUnit.getUniformPath());
                    executionUnit.addTest(testInfoContainer.getUniformPath());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.error("Dropping coverage for " + test.uniformPath + " due to error: ", (Throwable)ex);
                }
            }
        }
    }

    private ExecutionUnit constructExecutionUnitContainer(ExecutionUnitInfo executionUnitInfo, List<FileInfo> files, boolean partOfPartialReport) throws ReportParserException {
        UniformPath executableUnitUniformPath = TestUniformPathUtils.convertToExecutionUnitUniformPath((String)executionUnitInfo.getUniformPath().trim());
        String path = StringPool.intern((String)executableUnitUniformPath.toString());
        ExecutionUnit executionUnit = this.coverageInfoRetriever.createExecutionUnit(path);
        executionUnit.setHash(executionUnitInfo.getHash());
        if (executionUnitInfo.getDurationSeconds() == null) {
            Double totalDuration = null;
            for (TestInfo test : executionUnitInfo.getTests()) {
                if (test.duration == null) continue;
                if (totalDuration == null) {
                    totalDuration = 0.0;
                }
                totalDuration = totalDuration + test.duration;
            }
            executionUnit.setDurationSeconds(totalDuration);
        } else {
            executionUnit.setDurationSeconds(executionUnitInfo.getDurationSeconds());
        }
        executionUnit.setResult(executionUnitInfo.getResult());
        executionUnit.setExternalLink(executionUnitInfo.getExternalLink());
        if (executionUnitInfo.getCoverage() == null) {
            throw new ReportParserException("Execution unit is missing coverage entry!");
        }
        CoverageUnitContainer coverageUnitContainer = this.coverageInfoRetriever.createCoverageUnitContainer(path);
        coverageUnitContainer.setPartOfPartialReport(partOfPartialReport);
        this.collectCoverage(executionUnitInfo.getCoverage(), executionUnitInfo.getUniformPath(), files, coverageUnitContainer.getCoverageInfo());
        return executionUnit;
    }

    private TestInfoContainer constructTestInfoContainer(TestInfo test, List<FileInfo> files, boolean isPartOfPartialReport, @Nullable String executionUnit) throws ReportParserException {
        TestInfoContainer currentTestInfo = this.createTestwiseCoverageInfo(test, this.coverageInfoRetriever, isPartOfPartialReport, executionUnit);
        currentTestInfo.setReadableName(test.readableName);
        currentTestInfo.setHash(test.hash);
        currentTestInfo.setDurationSeconds(test.duration);
        currentTestInfo.setResult(test.result);
        currentTestInfo.setProperties(test.properties);
        currentTestInfo.setExternalLink(test.externalLink);
        currentTestInfo.setMessage(test.message);
        currentTestInfo.setExecutionUnit(executionUnit);
        currentTestInfo.setAssociatedSpecItems(test.associatedSpecItems);
        if (test.coverage == null) {
            return currentTestInfo;
        }
        if (executionUnit != null) {
            throw new ReportParserException("Tests within an execution unit must not have coverage associated!");
        }
        CoverageUnitContainer coverageUnitContainer = this.coverageInfoRetriever.createCoverageUnitContainer(currentTestInfo.getUniformPath());
        coverageUnitContainer.setPartOfPartialReport(currentTestInfo.isPartOfPartialReport());
        this.collectCoverage(test.coverage, test.uniformPath, files, coverageUnitContainer.getCoverageInfo());
        return currentTestInfo;
    }

    private void collectCoverage(@NonNull Map<String, CompactLines> fileIndexToCoveredLines, String uniformPath, List<FileInfo> files, MultiFileRangeCoverageInfo coverageInfo) {
        for (Map.Entry<String, CompactLines> indexToCoveredLines : fileIndexToCoveredLines.entrySet()) {
            String unparsedIndex = indexToCoveredLines.getKey();
            int index = TestInfoContainerBuilderV2.parseIndexIntoFileArray(unparsedIndex, uniformPath, files.size());
            if (index == -1) {
                return;
            }
            FileInfo fileFromReport = files.get(Integer.parseInt(unparsedIndex));
            CompactLines coveredLines = indexToCoveredLines.getValue();
            this.addCoveredAndCoverableLines(coverageInfo, fileFromReport, coveredLines);
        }
    }

    private void addCoveredAndCoverableLines(MultiFileRangeCoverageInfo coverageInfo, FileInfo fileFromReport, CompactLines coveredLines) {
        Optional<String> bestMatchingPath = this.disablePlausibilityCheckForPathMapping ? this.matchingPathsLookup.lookupBestPath(fileFromReport.path, PathLookupOptions.defaults()) : this.matchingPathsLookup.lookupBestPath(fileFromReport.path, PathLookupOptions.withPlausibilityCheck(new TestWiseCoveragePathMatchingPlausibilityCheck(this.tokenElementLineInfoIndex, coveredLines)));
        if (bestMatchingPath.isPresent()) {
            String uniformPath = StringPool.intern((String)bestMatchingPath.get());
            coverageInfo.addLineCoverage(uniformPath, coveredLines);
            if (fileFromReport.coverableLines != null) {
                coverageInfo.addCoverableLines(uniformPath, fileFromReport.coverableLines);
            }
        }
    }

    private static int parseIndexIntoFileArray(String unparsedIndex, String uniformPath, int fileArraySize) {
        int index;
        try {
            index = Integer.parseInt(unparsedIndex);
            if (index < 0 || index >= fileArraySize) {
                LOGGER.error("Error parsing testwise coverage report. The index into the file array " + unparsedIndex + " is not a number. Path: " + uniformPath);
                return -1;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error parsing testwise coverage report. The index into the file array " + unparsedIndex + " is not a number. Path: " + uniformPath);
            return -1;
        }
        return index;
    }
}

