/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.generic;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.tools.message.ExternalAnalysisToolMessageManager;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.generic.ExternalFindingData;
import com.teamscale.index.report.generic.ExternalFindingFileData;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CaseInsensitiveMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class GenericExternalFindingsParser
extends ReportParserBase {
    private static final int MAX_TOO_LONG_MESSAGE_EXAMPLES = 10;
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean shouldLookUpPaths;
    private ExternalAnalysisToolMessageManager messageManager;
    private ExternalAnalysisImportInfos result;
    private int tooLongMessageCount = 0;
    private final List<String> tooLongMessageExamples = new ArrayList<String>();

    public GenericExternalFindingsParser(boolean shouldLookUpPaths) {
        this.shouldLookUpPaths = shouldLookUpPaths;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.result = null;
    }

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            ExternalFindingFileData[] externalFindingData = (ExternalFindingFileData[])JsonUtils.deserializeFromJsonWithNullCheck((String)report, ExternalFindingFileData[].class);
            this.parseReport(Arrays.asList(externalFindingData));
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    public void parseReport(List<ExternalFindingFileData> externalFindingData) throws ReportParserException {
        try {
            this.result = this.extractFindings(externalFindingData);
        }
        catch (StorageException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    public void parse(List<ExternalFindingFileData> externalFindingData) throws ReportParserException {
        this.resetState();
        this.parseReport(externalFindingData);
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() {
        return this.result;
    }

    private ExternalAnalysisImportInfos extractFindings(List<ExternalFindingFileData> externalFindingData) throws StorageException, ReportParserException {
        if (this.messageManager == null) {
            this.messageManager = ExternalAnalysisToolMessageManager.getInstance(EAnalysisTool.CUSTOM, this.externalFindingsGroupDescriptionIndex.getDescriptions(EAnalysisTool.CUSTOM));
        }
        CaseInsensitiveMap resultsByPath = new CaseInsensitiveMap();
        ExternalAnalysisImportInfos result = new ExternalAnalysisImportInfos();
        for (ExternalFindingFileData fileData : externalFindingData) {
            this.extractFinding(fileData, (CaseInsensitiveMap<ExternalAnalysisImportInfoFindings>)resultsByPath, result);
        }
        return result;
    }

    private void extractFinding(ExternalFindingFileData fileData, CaseInsensitiveMap<ExternalAnalysisImportInfoFindings> resultsByPath, ExternalAnalysisImportInfos result) throws ReportParserException {
        String uploadedPath;
        fileData.validate();
        String path = uploadedPath = fileData.getPath();
        if (this.shouldLookUpPaths) {
            Optional<String> lookedUpPath = this.matchingPathsLookup.lookupBestPath(uploadedPath, PathLookupOptions.defaults());
            if (lookedUpPath.isEmpty()) {
                LOGGER.warn("Obtained external results for a file that is not in the index: {}", (Object)uploadedPath);
                return;
            }
            path = lookedUpPath.orElse(uploadedPath);
        }
        List<DetachedFinding> findings = this.getFindings(this.messageManager, fileData, path);
        ExternalAnalysisImportInfoFindings externalFindings = new ExternalAnalysisImportInfoFindings(path, findings, fileData.getContent());
        if (resultsByPath.containsKey((Object)path)) {
            LOGGER.warn("Received multiple uploads for '{}' (Report path: {}). Same report uploaded twice or maybe the paths only differ in casing? Attempting to merge findings.", (Object)path, (Object)uploadedPath);
            ((ExternalAnalysisImportInfoFindings)resultsByPath.get((Object)path)).mergeFindings(externalFindings);
        } else {
            result.addInfo(externalFindings);
            resultsByPath.put(path, (Object)externalFindings);
        }
    }

    private List<DetachedFinding> getFindings(ExternalAnalysisToolMessageManager messageManger, ExternalFindingFileData externalFindingFileData, String path) {
        ArrayList<DetachedFinding> findings = new ArrayList<DetachedFinding>();
        for (ExternalFindingData externalFindingData : externalFindingFileData.getFindings()) {
            if (externalFindingData != null) {
                try {
                    DetachedFinding finding = this.createFinding(path, externalFindingData, messageManger);
                    findings.add(finding);
                }
                catch (AssertionError | Exception e) {
                    LOGGER.error("Assertion error occurred for finding: {}", (Object)externalFindingData, e);
                }
                continue;
            }
            LOGGER.warn("Unexpected external finding null.");
        }
        if (this.tooLongMessageCount > 0) {
            LOGGER.warn("{} finding messages have been truncated as they exceeded the limit of 1000 characters! Examples are logged below.", (Object)this.tooLongMessageCount);
            this.tooLongMessageExamples.forEach(message -> LOGGER.warn("Too long message: {}", message));
        }
        return findings;
    }

    private DetachedFinding createFinding(String path, ExternalFindingData externalFindingData, ExternalAnalysisToolMessageManager messageManger) throws ReportParserException {
        Object location;
        GenericExternalFindingsParser.checkTypeIdAndMessagePresent(externalFindingData);
        if (externalFindingData.getEndOffset() != null && externalFindingData.getStartOffset() != null) {
            location = new TextRegionLocation(path, externalFindingData.getStartOffset().intValue(), externalFindingData.getEndOffset().intValue(), GenericExternalFindingsParser.handleNull(externalFindingData.getStartLine()), GenericExternalFindingsParser.handleNull(externalFindingData.getEndLine()));
        } else if (externalFindingData.getStartLine() != null) {
            Integer endLine = externalFindingData.getEndLine();
            if (endLine == null) {
                endLine = externalFindingData.getStartLine();
            }
            location = new TextRegionLocation(path, -1, -1, externalFindingData.getStartLine().intValue(), endLine.intValue());
        } else {
            location = !StringUtils.isEmpty((String)externalFindingData.getIdentifier()) ? new QualifiedNameLocation(externalFindingData.getIdentifier(), path) : new ElementLocation(path);
        }
        return this.createFinding(externalFindingData, (ElementLocation)location, messageManger);
    }

    private DetachedFinding createFinding(ExternalFindingData externalFindingData, ElementLocation location, ExternalAnalysisToolMessageManager messageManger) {
        String message = externalFindingData.getMessage();
        if (message.length() > 1000) {
            if (this.tooLongMessageExamples.size() < 10) {
                this.tooLongMessageExamples.add(message);
            }
            ++this.tooLongMessageCount;
            message = StringUtils.truncateWithEllipsis((String)message, (int)1000);
        }
        return new DetachedFinding(externalFindingData.getFindingTypeId(), messageManger.getFindingCategoryName(), message, location, externalFindingData.getAssessment(), externalFindingData.getProperties());
    }

    private static void checkTypeIdAndMessagePresent(ExternalFindingData externalFindingData) throws ReportParserException {
        if (StringUtils.isEmpty((String)externalFindingData.getFindingTypeId()) || StringUtils.isEmpty((String)externalFindingData.getMessage())) {
            throw new ReportParserException("Finding data is not complete: " + String.valueOf(externalFindingData));
        }
    }

    private static int handleNull(Integer line) {
        if (line == null) {
            return 0;
        }
        return line;
    }
}

