/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.external.result.ExternalAnalysisResultExecutionUnit;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultExecutionUnitProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultExecutionUnit> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExecutionUnitIndex executionUnitIndex;
    private final Map<String, Map<String, ExecutionUnit>> executableUnits = new HashMap<String, Map<String, ExecutionUnit>>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isExecutionUnit();
    }

    @Override
    public Class<ExternalAnalysisResultExecutionUnit> getResultClass() {
        return ExternalAnalysisResultExecutionUnit.class;
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultExecutionUnit analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        this.executableUnits.computeIfAbsent(partition, key -> new HashMap()).put(uniformPath.toString(), analysisResult.getData());
        return true;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        if (this.executableUnits.isEmpty()) {
            return;
        }
        this.executionUnitIndex.purgeFromOtherBranches(this.executableUnits.keySet());
        this.executionUnitIndex.setExecutionUnits(this.executableUnits);
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        this.executionUnitIndex.removeExecutionUnits(deletedPartitionAndPaths);
    }

    @Override
    public void reset() {
        this.executableUnits.clear();
    }
}

