/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.junit;

import com.teamscale.index.report.testexecution.TestReportParserBase;
import com.teamscale.index.utils.LocaleIndependentDoubleParser;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JUnitReportParser
extends TestReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TESTCASE_ELEMENT = "testcase";
    private static final Pattern JUNIT_TEST_START_PATTERN = Pattern.compile("(?s)^([^( \\W]+\\([^)]*\\))(.*)");

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            XMLUtils.parseSAX((String)report, (DefaultHandler)new JUnitSaxHandler());
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
        catch (SkipReportException e) {
            LOGGER.warn("Skipped parsing of report " + Optional.ofNullable(reportPath).orElse("<unknown>") + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static String truncateLongParameterizedTests(String testName) {
        if (testName.length() <= 400) {
            return testName;
        }
        Matcher matcher = JUNIT_TEST_START_PATTERN.matcher(testName);
        if (!matcher.matches()) {
            return testName;
        }
        String shortenedTestName = TestExecution.Builder.buildTruncatedTestName((String)matcher.group(1), (String)matcher.group(2));
        if (shortenedTestName.length() <= 347) {
            return shortenedTestName;
        }
        return testName;
    }

    private class JUnitSaxHandler
    extends DefaultHandler {
        private String currentTestSuiteName;
        private TestExecution.Builder currentTestCase;
        private final StringBuilder currentText = new StringBuilder();
        private String errorMessage;

        private JUnitSaxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentText.setLength(0);
            if (JUnitReportParser.TESTCASE_ELEMENT.equals(localName)) {
                this.enterTestCase(attributes);
            } else if ("testsuite".equals(localName)) {
                this.enterTestSuite(attributes);
            } else if ("error".equals(localName)) {
                this.errorMessage = attributes.getValue("message");
            } else if ("failsafe-summary".equalsIgnoreCase(localName)) {
                throw new SkipReportException("Invalid file format. JUnit summary files should not be uploaded!");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (localName) {
                case "testcase": {
                    JUnitReportParser.this.reportTestExecution(this.currentTestCase);
                    this.currentTestCase = null;
                    break;
                }
                case "failure": {
                    this.handleFailedTest(ETestExecutionResult.FAILURE);
                    break;
                }
                case "error": {
                    this.handleFailedTest(ETestExecutionResult.ERROR);
                    break;
                }
                case "skipped": {
                    this.currentTestCase.setResult(ETestExecutionResult.SKIPPED);
                }
            }
        }

        private void handleFailedTest(ETestExecutionResult failure) throws SAXException {
            if (this.currentTestCase == null) {
                throw new SAXException("Encountered failure or error element outside of testcase element!");
            }
            if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
                this.currentText.append(this.currentText.length() == 0 ? "" : "\nMessage: ").append(this.errorMessage);
            }
            this.currentTestCase.setResult(failure);
            this.currentTestCase.setFailureMessage(this.currentText.toString());
        }

        private void enterTestSuite(Attributes attributes) {
            this.currentTestSuiteName = attributes.getValue("name");
        }

        private void enterTestCase(Attributes attributes) throws SAXException {
            if (this.currentTestCase != null) {
                throw new SAXException("Not expecting nested test cases!");
            }
            String name = JUnitReportParser.truncateLongParameterizedTests(attributes.getValue("name"));
            String className = attributes.getValue("classname");
            this.currentTestCase = !StringUtils.isEmpty((CharSequence)className) ? TestExecution.Builder.fromClassAndName((String)className, (String)name) : (!StringUtils.isEmpty((CharSequence)this.currentTestSuiteName) && !this.currentTestSuiteName.equals(name) ? TestExecution.Builder.fromClassAndName((String)this.currentTestSuiteName, (String)name) : TestExecution.Builder.fromRelativePath((String)name));
            String timeValue = attributes.getValue("time");
            if (timeValue != null) {
                this.currentTestCase.setDurationInSeconds(LocaleIndependentDoubleParser.parseDouble(timeValue));
            }
            if (Boolean.parseBoolean(attributes.getValue("ignored"))) {
                this.currentTestCase.setResult(ETestExecutionResult.IGNORED);
            } else {
                this.currentTestCase.setResult(ETestExecutionResult.PASSED);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currentTestCase != null) {
                this.currentText.append(ch, start, length);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    private static class SkipReportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SkipReportException(String message) {
            super(message);
        }
    }
}

