/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.StepParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ambiguous_language.AmbiguousLanguageResolutionUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.LanguageInfo;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class LanguageMappingSupport {
    public static final String LANGUAGE_MAPPING_PARAMETER = "language-mapping";
    public static final String CONFIGURED_LANGUAGE_PARAMETER = "configured-language";
    @StepParameter(value="language-mapping", optional=true)
    @VisibleForTesting
    final PairList<String, ELanguage> languageMapping = new PairList();
    private PairList<Pattern, ELanguage> compiledLanguageMapping;
    @StepParameter(value="configured-language", optional=true)
    @VisibleForTesting
    final Set<ELanguage> configuredLanguages = new HashSet<ELanguage>();

    public LanguageInfo determineLanguageInfo(String uniformPath, String fileContent) throws ConQATException {
        if (this.compiledLanguageMapping == null) {
            this.compiledLanguageMapping = this.languageMapping.mapFirst(s -> AntPatternUtils.convertPatternSafe((String)s, (boolean)false));
        }
        for (int i = 0; i < this.compiledLanguageMapping.size(); ++i) {
            if (!((Pattern)this.compiledLanguageMapping.getFirst(i)).matcher(uniformPath).matches()) continue;
            return new LanguageInfo((ELanguage)this.compiledLanguageMapping.getSecond(i), true);
        }
        return new LanguageInfo(AmbiguousLanguageResolutionUtils.getLanguageFromUniformPath(this.configuredLanguages, (String)uniformPath, (String)fileContent), false);
    }
}

