/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.committree.EmptyCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import com.teamscale.index.repository.artifact_store.PatternBasedItemPathExtractor;
import com.teamscale.index.repository.artifact_store.revision_interpretation.CompoundCommitResolver;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionInterpretationFactory;
import com.teamscale.index.repository.artifact_store.revision_interpretation.IRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ItemPathBasedCommitResolver;
import com.teamscale.index.repository.artifact_store.revision_interpretation.RevisionInterpretationContext;
import com.teamscale.index.utils.CollectionValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CompoundCommitResolverDescriptor {
    private static final String EXTRACTION_PATTERNS_AND_INTERPRETATIONS_NAME = "patterns-and-interpretations";
    @JsonProperty(value="patterns-and-interpretations")
    private final PairList<String, String> extractionPatternsAndInterpretations;

    @JsonCreator
    private CompoundCommitResolverDescriptor(@JsonProperty(value="patterns-and-interpretations") PairList<String, String> extractionPatternsAndInterpretations) {
        Preconditions.checkArgument((!extractionPatternsAndInterpretations.isEmpty() ? 1 : 0) != 0, (Object)"At least one extraction pattern and interpretation must be provided.");
        this.extractionPatternsAndInterpretations = extractionPatternsAndInterpretations;
    }

    @SafeVarargs
    public CompoundCommitResolverDescriptor(Pair<String, String> extractionPatternAndInterpretation, Pair<String, String> ... extractionPatternsAndInterpretations) {
        this.extractionPatternsAndInterpretations = PairList.fromPairs(extractionPatternAndInterpretation, extractionPatternsAndInterpretations);
    }

    public Optional<String> getReferencedConnectorId() throws IllegalStateException {
        return this.extractionPatternsAndInterpretations.getSecondList().stream().map(interpretationDescriptor -> {
            try {
                return ERevisionInterpretationFactory.getReferencedConnectorId(interpretationDescriptor).orElse(null);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Invalid referenced connector ID: " + interpretationDescriptor, e);
            }
        }).filter(Objects::nonNull).findFirst();
    }

    public CompoundCommitResolver compile(RevisionInterpretationContext context, boolean allowExtractionFailures) throws RepositoryException {
        ArrayList<IArtifactStoreCommitResolver> resolvers = new ArrayList<IArtifactStoreCommitResolver>();
        for (Pair extractionPatternAndInterpretation : this.extractionPatternsAndInterpretations) {
            PatternBasedItemPathExtractor extractor = PatternBasedItemPathExtractor.create((String)extractionPatternAndInterpretation.getFirst(), "revision");
            IRevisionInterpretation interpretation = ERevisionInterpretationFactory.createFromDescriptor((String)extractionPatternAndInterpretation.getSecond(), context);
            resolvers.add(new ItemPathBasedCommitResolver(extractor, interpretation));
        }
        return new CompoundCommitResolver(resolvers, allowExtractionFailures);
    }

    public boolean validateRevision(String revision, @Nullable String branchName, RevisionInterpretationContext revisionInterpretationContext) {
        boolean bl;
        block8: {
            CompoundCommitResolver resolver = this.compile(revisionInterpretationContext, true);
            try {
                bl = resolver.resolveCommit(revision, branchName).isPresent();
                if (resolver == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
            resolver.close();
        }
        return bl;
    }

    public void validate(ConfigurationInitializationContext context) throws ConnectorValidationException {
        if (this.extractionPatternsAndInterpretations.isEmpty()) {
            throw new ConnectorValidationException("No extraction patterns were provided.");
        }
        CompoundCommitResolverDescriptor.validatePatterns(this.extractionPatternsAndInterpretations.extractFirstList());
        CompoundCommitResolverDescriptor.validateInterpretations(this.extractionPatternsAndInterpretations.extractSecondList(), context);
        this.validateReferencedConnectorId();
    }

    private static void validatePatterns(List<String> patterns) throws ConnectorValidationException {
        CollectionValidationUtils.validateCollection(patterns, pattern -> ConnectorUtils.validateCapturingGroupInRegexPattern((String)pattern, (String)"Extraction pattern"));
    }

    private void validateReferencedConnectorId() throws ConnectorValidationException {
        List<String> referencedConnectorIds = CollectionValidationUtils.validateAndMap(this.extractionPatternsAndInterpretations.extractSecondList(), ERevisionInterpretationFactory::getReferencedConnectorId).stream().filter(Optional::isPresent).map(Optional::get).toList();
        if (referencedConnectorIds.size() > 1) {
            throw new ConnectorValidationException("Configuration references multiple connectors, but at most one connector reference is supported: [%s].".formatted(String.join((CharSequence)", ", referencedConnectorIds)));
        }
    }

    private static void validateInterpretations(List<String> interpretations, ConfigurationInitializationContext context) throws ConnectorValidationException {
        CollectionValidationUtils.validateCollection(interpretations, CompoundCommitResolverDescriptor.validateInterpretation(context));
    }

    private static ConsumerWithException<String, Exception> validateInterpretation(ConfigurationInitializationContext context) {
        return interpretation -> CompoundCommitResolverDescriptor.validateInterpretationWithContext(context, interpretation);
    }

    private static void validateInterpretationWithContext(ConfigurationInitializationContext context, String interpretation) throws ConnectorValidationException {
        try {
            if (ERevisionInterpretationFactory.getReferencedConnectorId(interpretation).isPresent()) {
                return;
            }
            RevisionInterpretationContext revisionInterpretationContext = new RevisionInterpretationContext(context.getExternalCredentialsProvider(), Collections.emptySet(), null, (SupplierWithException<ICommitTree, RepositoryException>)((SupplierWithException)EmptyCommitTree::new), null, new RepositoryRevisionIndex());
            ERevisionInterpretationFactory.createFromDescriptor(interpretation, revisionInterpretationContext).close();
            if (interpretation.toLowerCase().startsWith(ERevisionInterpretationFactory.DATE.name().toLowerCase()) && interpretation.contains("Y")) {
                throw new ConnectorValidationException("Found uppercase 'Y' in date pattern '" + interpretation + "', which refers to the week year. You will probably want to use lowercase 'y' instead.");
            }
        }
        catch (RepositoryException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }
}

