/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.google.common.collect.Iterables;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.repository.artifact_store.revision_interpretation.CommitCachingDecorator;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ConnectorIndependentRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ConnectorRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.GitConnectorRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.GitRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.IRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.RevisionInterpretationContext;
import com.teamscale.index.repository.artifact_store.revision_interpretation.RevisionIsDateInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.RevisionIsTimestampInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.SvnRevisionInterpretation;
import java.util.Optional;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public enum ERevisionInterpretationFactory {
    DATE{

        @Override
        protected IRevisionInterpretation createFromParameter(String descriptorParameter, RevisionInterpretationContext revisionInterpretationContext) throws RepositoryException {
            return RevisionIsDateInterpretation.create(descriptorParameter);
        }
    }
    ,
    TIMESTAMP{

        @Override
        protected IRevisionInterpretation createFromParameter(String descriptorParameter, RevisionInterpretationContext revisionInterpretationContext) throws RepositoryException {
            return RevisionIsTimestampInterpretation.create(descriptorParameter);
        }
    }
    ,
    SVN{

        @Override
        protected IRevisionInterpretation createFromParameter(String descriptorParameter, RevisionInterpretationContext revisionInterpretationContext) throws RepositoryException {
            SvnRevisionInterpretation svnRevisionInterpretation = new SvnRevisionInterpretation(ERevisionInterpretationFactory.resolveCredentials(descriptorParameter, revisionInterpretationContext.externalCredentialsProvider()));
            if (revisionInterpretationContext.artifactStoreCommitResolutionCacheIndex() == null) {
                return svnRevisionInterpretation;
            }
            return new CommitCachingDecorator(svnRevisionInterpretation, revisionInterpretationContext.foreignRepositoryIdentifier(), revisionInterpretationContext.artifactStoreCommitResolutionCacheIndex());
        }
    }
    ,
    GIT{

        @Override
        protected IRevisionInterpretation createFromParameter(String descriptorParameter, RevisionInterpretationContext revisionInterpretationContext) throws RepositoryException {
            return new GitRevisionInterpretation(ERevisionInterpretationFactory.resolveCredentials(descriptorParameter, revisionInterpretationContext.externalCredentialsProvider()));
        }
    }
    ,
    CONNECTOR(true){

        @Override
        protected IRevisionInterpretation createFromParameter(String descriptorParameter, RevisionInterpretationContext revisionInterpretationContext) {
            if (StringUtils.isEmpty((String)descriptorParameter)) {
                return new ConnectorIndependentRevisionInterpretation(revisionInterpretationContext.repositoryRevisionIndex());
            }
            if (!revisionInterpretationContext.foreignRepositoryConnectorTypes().isEmpty() && ERepositoryConnector.isGitBasedConnector((ERepositoryConnector)((ERepositoryConnector)Iterables.getOnlyElement(revisionInterpretationContext.foreignRepositoryConnectorTypes())))) {
                return new GitConnectorRevisionInterpretation(revisionInterpretationContext.getForeignCommitTreeSupplier());
            }
            return new ConnectorRevisionInterpretation(revisionInterpretationContext.getForeignCommitTreeSupplier());
        }
    };

    private final boolean isParameterOptional;

    private ERevisionInterpretationFactory(boolean isParameterOptional) {
        this.isParameterOptional = isParameterOptional;
    }

    private ERevisionInterpretationFactory() {
        this(false);
    }

    public static IRevisionInterpretation createFromDescriptor(String stringDescriptor, RevisionInterpretationContext revisionInterpretationContext) throws RepositoryException {
        RevisionInterpretationDescriptor descriptor = RevisionInterpretationDescriptor.fromString(stringDescriptor);
        return descriptor.interpretation().createFromParameter(descriptor.parameter().orElse(""), revisionInterpretationContext);
    }

    public static Optional<String> getReferencedConnectorId(String interpretationDescriptor) throws RepositoryException {
        RevisionInterpretationDescriptor descriptor = RevisionInterpretationDescriptor.fromString(interpretationDescriptor);
        if (descriptor.interpretation() == CONNECTOR) {
            return descriptor.parameter();
        }
        return Optional.empty();
    }

    protected abstract IRevisionInterpretation createFromParameter(String var1, RevisionInterpretationContext var2) throws RepositoryException;

    private static ExternalCredentials resolveCredentials(String id, IExternalCredentialsProvider externalCredentialsProvider) throws RepositoryException {
        try {
            ExternalCredentials credentials = externalCredentialsProvider.getExternalCredentials(id);
            if (credentials == null) {
                throw new RepositoryException("Credentials with id " + id + " not found!");
            }
            return credentials;
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private record RevisionInterpretationDescriptor(ERevisionInterpretationFactory interpretation, Optional<String> parameter) {
        private static RevisionInterpretationDescriptor fromString(String rawDescriptor) throws RepositoryException {
            String[] parts = rawDescriptor.split(":", 2);
            ERevisionInterpretationFactory interpretation = RevisionInterpretationDescriptor.determineInterpretation(parts[0]);
            if (!interpretation.isParameterOptional && parts.length < 2) {
                throw new RepositoryException("Invalid timestamp interpretation '%s': missing colon!".formatted(rawDescriptor));
            }
            return new RevisionInterpretationDescriptor(interpretation, parts.length == 2 ? Optional.of(parts[1]) : Optional.empty());
        }

        private static ERevisionInterpretationFactory determineInterpretation(String interpretationName) throws RepositoryException {
            ERevisionInterpretationFactory factory = (ERevisionInterpretationFactory)EnumUtils.valueOfIgnoreCase(ERevisionInterpretationFactory.class, (String)interpretationName);
            if (factory == null) {
                throw new RepositoryException("Unknown timestamp interpretation: '%s'".formatted(interpretationName));
            }
            return factory;
        }
    }
}

