/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.NonNull;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED}, valueClasses={String.class})
public class S3ArchiveIndex
extends ArchiveIndexBase {
    public static final String BASE_NAME = "s3-archive-content";
    private static final int MAX_RETRY_COUNT = Integer.parseInt(System.getProperty("com.teamscale.s3.max-download-retry-count", "3"));

    public S3ArchiveIndex(IStore store) {
        super(store);
    }

    public static @NonNull String createIndexName(String connectionIdentifier) {
        return connectionIdentifier + "-s3-archive-content";
    }

    @Override
    protected int getMaximumRetryCount() {
        return MAX_RETRY_COUNT;
    }

    public static S3ArchiveIndex open(ProjectStorageSystem projectStorageSystem, String connectorIdentifier) throws StorageException {
        return (S3ArchiveIndex)projectStorageSystem.openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName(connectorIdentifier), null);
    }

    public void runWithIncrementalScanLock(IncrementalScanOperation operation) throws StorageException {
        LockedIncrementalScanIndex lockedIndex = new LockedIncrementalScanIndex(this.store);
        try {
            operation.run(lockedIndex);
        }
        finally {
            lockedIndex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeWithIncrementalScanLock(IncrementalScanComputation<T> computation) throws StorageException {
        LockedIncrementalScanIndex lockedIndex = new LockedIncrementalScanIndex(this.store);
        try {
            T t = computation.compute(lockedIndex);
            return t;
        }
        finally {
            lockedIndex.unlock();
        }
    }

    @Override
    protected boolean shouldResetFullScanTimestampOnRollback() {
        return false;
    }

    public static class LockedIncrementalScanIndex
    implements IUtilityIndex {
        private static final String INCREMENTAL_SCAN_LOCK = "incremental-scan-lock";
        private static final String INCREMENTAL_SCAN_KEYS = "###incremental-scan-keys###";
        private static final String MISSED_ENTRIES_COUNT = "###missed-entries-count###";
        private static final String FORCE_FULL_SCAN = "###force-full-scan###";
        public static final byte[] FORCE_FULL_SCAN_VALUE = new byte[]{1};
        public static final byte[] NO_FULL_SCAN_REQUIRED_VALUE = new byte[]{0};
        private final ConvenientStore store;
        private final Lock lock;

        private LockedIncrementalScanIndex(ConvenientStore store) {
            this.store = store;
            this.lock = store.obtainLock(INCREMENTAL_SCAN_LOCK);
            this.lock.lock();
        }

        public IStore getWrappedStore() {
            return this.store;
        }

        private void unlock() {
            this.lock.unlock();
        }

        public void addKeysForIncrementalScan(Set<String> keysToScan) throws StorageException {
            Set<String> existingKeys = this.getKeysToScanIncrementallyWithoutLock();
            existingKeys.addAll(keysToScan);
            this.storeKeysToScanIncrementallyWithoutLock(existingKeys);
        }

        public void removeKeysToScanIncrementally(Set<String> processedKeys) throws StorageException {
            Set<String> storedKeys = this.getKeysToScanIncrementallyWithoutLock();
            storedKeys.removeAll(processedKeys);
            this.storeKeysToScanIncrementallyWithoutLock(storedKeys);
            CounterSet<String> missedEntryCounts = this.getMissedEntryCounts();
            missedEntryCounts.removeAll(processedKeys);
            this.storeMissedEntryCountsWithoutLock(missedEntryCounts);
        }

        public Set<String> getKeysToScanIncrementally() throws StorageException {
            return this.getKeysToScanIncrementallyWithoutLock();
        }

        public void incrementAndStoreMissedCounts(Set<String> missedEntries) throws StorageException {
            CounterSet<String> countedMisses = this.getMissedEntryCounts();
            countedMisses.incAll(missedEntries);
            this.storeMissedEntryCountsWithoutLock(countedMisses);
        }

        public CounterSet<String> getMissedEntryCounts() throws StorageException {
            byte[] rawValue = this.store.getWithString(MISSED_ENTRIES_COUNT);
            if (rawValue == null) {
                return new CounterSet();
            }
            return (CounterSet)StorageUtils.deserialize((byte[])rawValue);
        }

        private void storeKeysToScanIncrementallyWithoutLock(Set<String> keys) throws StorageException {
            this.store.putWithString(INCREMENTAL_SCAN_KEYS, StorageUtils.serialize(new ArrayList<String>(keys)));
        }

        private Set<String> getKeysToScanIncrementallyWithoutLock() throws StorageException {
            List keysToScan = (List)((Object)StorageUtils.deserialize((byte[])this.store.getWithString(INCREMENTAL_SCAN_KEYS)));
            if (keysToScan == null) {
                return new HashSet<String>();
            }
            return new HashSet<String>(keysToScan);
        }

        private void storeMissedEntryCountsWithoutLock(CounterSet<String> missedEntryCounts) throws StorageException {
            if (missedEntryCounts.isEmpty()) {
                this.store.removeWithString(MISSED_ENTRIES_COUNT);
            } else {
                this.store.putWithString(MISSED_ENTRIES_COUNT, StorageUtils.serialize(missedEntryCounts));
            }
        }

        public boolean isForceFullScan() throws StorageException {
            byte[] result = this.store.getWithString(FORCE_FULL_SCAN);
            return result != null && result[0] == FORCE_FULL_SCAN_VALUE[0];
        }

        public void setForceFullScan(boolean forceFullScan) throws StorageException {
            if (forceFullScan) {
                this.store.putWithString(FORCE_FULL_SCAN, FORCE_FULL_SCAN_VALUE);
            } else {
                this.store.putWithString(FORCE_FULL_SCAN, NO_FULL_SCAN_REQUIRED_VALUE);
            }
        }
    }

    @FunctionalInterface
    public static interface IncrementalScanOperation {
        public void run(LockedIncrementalScanIndex var1) throws StorageException;
    }

    @FunctionalInterface
    public static interface IncrementalScanComputation<T> {
        public T compute(LockedIncrementalScanIndex var1) throws StorageException;
    }
}

