/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

class RevisionParameterProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TriggerBuilder trigger;
    private final ConnectorDescriptorBase.ITriggerCreator triggerCreator;
    private final String repositoryIdentifier;

    public RevisionParameterProcessor(TriggerBuilder trigger, ConnectorDescriptorBase.ITriggerCreator triggerCreator, String repositoryIdentifier) {
        this.trigger = trigger;
        this.triggerCreator = triggerCreator;
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public Optional<String> calculateRevisionValue(String descriptorParameterName, String triggerParameterName, String revisionValue) throws ProjectConfigurationException {
        if (StringUtils.isEmpty((String)revisionValue) || "0".equals(revisionValue)) {
            return Optional.empty();
        }
        if (this.parameterNewOrHasChanged(descriptorParameterName, revisionValue)) {
            return Optional.of(ConnectorUtils.replaceRelativeDate((String)revisionValue));
        }
        return this.extractPreviousValue(triggerParameterName).or(() -> Optional.of(ConnectorUtils.replaceRelativeDate((String)revisionValue)));
    }

    private Optional<String> extractPreviousValue(String parameterName) throws ProjectConfigurationException {
        List previousTriggers = this.triggerCreator.getPreviousTriggers();
        if (previousTriggers == null) {
            throw new ProjectConfigurationException("Could not retrieve previous trigger, even though the parameter was present previously: " + parameterName);
        }
        Optional<AnalysisTrigger> previousTrigger = previousTriggers.stream().filter(analysisTrigger -> analysisTrigger.getName().equals(TriggerBuilder.buildTriggerName((String)this.repositoryIdentifier, (String)this.trigger.getSimpleTriggerName()))).findFirst();
        if (previousTrigger.isEmpty()) {
            LOGGER.warn("Could not extract previous trigger, even though we expected to find it. Repository identifier: " + this.repositoryIdentifier);
            return Optional.empty();
        }
        Optional previousValue = previousTrigger.get().getDescription().getTriggerParameters().getParameter((Object)parameterName);
        if (previousValue.isEmpty()) {
            LOGGER.warn("Could not extract previous value for parameter '" + parameterName + "' even though we expected to find it on repository: " + this.repositoryIdentifier);
            return Optional.empty();
        }
        return Optional.of(((TriggerDescription.Parameter)previousValue.get()).getValue().asText());
    }

    private boolean parameterNewOrHasChanged(String parameterName, String newValue) {
        return this.triggerCreator.getConnectorFromPreviousConfiguration(this.repositoryIdentifier).map(oldConnectorConfig -> !Objects.equals(oldConnectorConfig.getOptionValue(parameterName), newValue)).orElse(true);
    }
}

