/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.index.repository.IRevisionResolver;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitPreviewUtils;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.nio.file.Path;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.transaction.TransactionalStorageSystem;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.lib.Ref;

public class GitRevisionResolver
implements IRevisionResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final GitRepositoryConnectorDescriptor gitConnectorDescriptor;
    private final GlobalStorageSystem globalStorageSystem;
    private final ProjectStorageSystem projectStorageSystem;
    private final ExternalCredentials credentials;
    private final String repositoryNameOrPathSuffix;
    private final Path cloneDirectory;

    public GitRevisionResolver(GitRepositoryConnectorDescriptor gitConnectorDescriptor, String repositoryNameOrPathSuffix, InternalProjectId project, ExternalCredentials credentials, IndexLayer indexLayer) throws StorageException {
        this.gitConnectorDescriptor = gitConnectorDescriptor;
        this.globalStorageSystem = indexLayer.openGlobalStorageSystem();
        StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider = indexLayer.getStorageSystemCacheProvider(project.toString());
        TransactionalStorageSystem transactionStorageSystem = new TransactionalStorageSystem((IStorageSystem)indexLayer.openProjectStorageSystem((IProjectId)project), storageSystemCacheProvider, InMemoryStore::new);
        this.projectStorageSystem = new ProjectStorageSystem((IStorageSystem)transactionStorageSystem, storageSystemCacheProvider);
        this.repositoryNameOrPathSuffix = repositoryNameOrPathSuffix;
        this.credentials = credentials;
        this.cloneDirectory = RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)((ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class)));
    }

    @Override
    public Optional<CommitDescriptor> resolveToCommitDescriptor(String revision) throws StorageException {
        if (this.credentials == null) {
            LOGGER.error("External credentials of account '{}' for GitRevisionResolver for repository '{}' in connector '{}' are missing.", (Object)this.gitConnectorDescriptor.getAccountIdentifier(), (Object)this.repositoryNameOrPathSuffix, (Object)this.gitConnectorDescriptor.getConnectorIdentifier());
            return Optional.empty();
        }
        try {
            GitRepositoryInfoIndex gitInfoIndex = this.openGitInfoIndex();
            GitRepositoryConnection connection = this.getConnection(gitInfoIndex);
            this.synchronizeRepository(connection);
            return GitRevisionResolver.resolveRevision(connection, gitInfoIndex, revision, this.gitConnectorDescriptor.getBranchTransformation());
        }
        catch (ProjectConfigurationException | NoSuchElementException | RepositoryException e) {
            LOGGER.warn("GitRevisionResolver failed to find revision in this repository connector. This can happen, as we sometimes try to find the revision in _any_ of the configured connectors in a project.Tried to find revision '{}' using repository connector '{}'. Tried connecting with credentials '{}'.", (Object)revision, (Object)this.gitConnectorDescriptor.getConnectorIdentifier(), (Object)this.credentials.credentialsName);
            return Optional.empty();
        }
    }

    public Optional<CommitDescriptor> resolveTagToCommitDescriptor(String tagName) throws StorageException {
        if (this.credentials == null) {
            return Optional.empty();
        }
        try {
            GitRepositoryConnection connection = this.getConnection(this.openGitInfoIndex());
            String revision = GitUtils.getTaggedRevision(connection.getRepository(), tagName).orElseThrow();
            return GitRevisionResolver.resolveRevision(connection, this.openGitInfoIndex(), revision, this.gitConnectorDescriptor.getBranchTransformation());
        }
        catch (ProjectConfigurationException | NoSuchElementException | RepositoryException e) {
            LOGGER.warn("Could not resolve tag: {} in Git repository at URI: {}", (Object)tagName, (Object)this.credentials.uri, (Object)e);
            return Optional.empty();
        }
    }

    public PairList<String, String> getRefsByPrefix(Map<String, Pattern> requestedRefs, boolean synchronizeRepository) throws StorageException {
        if (this.credentials == null) {
            return new PairList();
        }
        try {
            GitRepositoryConnection connection = this.getConnection(this.openGitInfoIndex());
            if (synchronizeRepository) {
                this.synchronizeRepository(connection);
            }
            PairList resultRefs = new PairList();
            for (Map.Entry<String, Pattern> requestedRefsEntry : requestedRefs.entrySet()) {
                connection.getRefsByPrefix(requestedRefsEntry.getKey()).stream().map(ref -> GitRevisionResolver.asRefNamePair(ref, requestedRefsEntry)).forEach(arg_0 -> ((PairList)resultRefs).add(arg_0));
            }
            return resultRefs;
        }
        catch (ProjectConfigurationException | NoSuchElementException | RepositoryException e) {
            LOGGER.warn("Failed to read requested refs from Git repository at URI: {}", (Object)this.credentials.uri, (Object)e);
            return new PairList();
        }
    }

    private static Pair<String, String> asRefNamePair(Ref ref, Map.Entry<String, Pattern> requestedRefsEntry) {
        Matcher matcher = requestedRefsEntry.getValue().matcher(ref.getName());
        String displayName = null;
        if (matcher.find()) {
            displayName = matcher.group(1);
        }
        if (StringUtils.isEmpty(displayName)) {
            LOGGER.debug("Pattern `{}` for extracting display name failed to extract a display name for ref '{}'.", (Object)matcher.pattern(), (Object)ref.getName());
            displayName = ref.getName();
        }
        return new Pair((Object)ref.getName(), (Object)displayName);
    }

    private static Optional<CommitDescriptor> resolveRevision(GitRepositoryConnection connection, GitRepositoryInfoIndex gitInfoIndex, String revision, StringTransformation branchTransformations) throws RepositoryException, StorageException, ProjectConfigurationException {
        BranchRenamingCommitTreeFacade commitTree = new BranchRenamingCommitTreeFacade(branchTransformations, new CommitTreeIndex((IStore)new InMemoryStore()));
        String branchName = gitInfoIndex.getBranchNamesByCommitName().get(revision);
        if (branchName == null) {
            connection.runPathBuildingAlgorithmAndPersistResults(commitTree);
            branchName = gitInfoIndex.getBranchNamesByCommitName().getOrDefault(revision, connection.getDefaultBranchName());
        }
        Optional<Long> optionalTimestamp = GitUtils.getTimestampFromRevision(connection.getRepository(), revision);
        String finalBranchName = branchName;
        return optionalTimestamp.map(timestamp -> new CommitDescriptor(commitTree.renameBranch(finalBranchName), timestamp.longValue()));
    }

    private void synchronizeRepository(GitRepositoryConnection connection) throws RepositoryException, ProjectConfigurationException {
        EGitProtocol protocol = GitPreviewUtils.getGitProtocol(connection.repository.getLocation());
        if (protocol != EGitProtocol.FILE) {
            try {
                connection.doSynchronize();
            }
            catch (RepositoryException e) {
                LOGGER.warn("Could not synchronize repository before revision resolution (Uri: " + this.credentials.uri + "): " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private GitRepositoryConnection getConnection(GitRepositoryInfoIndex gitInfoIndex) throws RepositoryException, ProjectConfigurationException, StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        Optional<Object> keyOption = Optional.empty();
        if (this.gitConnectorDescriptor.getPrivateKeyId() != null) {
            keyOption = GitRepositoryConnector.getPrivateKeyOption(serverOptionIndex, this.gitConnectorDescriptor.getPrivateKeyId(), this.gitConnectorDescriptor.getAccountIdentifier());
        }
        GitCredentials gitCredentials = new GitCredentials(this.credentials, GitRepositoryConnector.adjustGitUrlAndConvertToUri(this.gitConnectorDescriptor.getRepositoryUri().toString()), keyOption.orElse(null));
        return new GitRepositoryConnection(this.buildBaseParameters(), this.buildGitParameters(this.getIndices(serverOptionIndex, gitInfoIndex)), gitCredentials, ICancelable.neverCanceled());
    }

    private RepositoryConnectorBaseParameterStep buildBaseParameters() {
        RepositoryConnectorBaseParameterStep.RepositoryConnectorBaseParameterStepBuilder parameterBuilder = RepositoryConnectorBaseParameterStep.builder("temp", this.gitConnectorDescriptor.getDefaultBranchName()).withBranchPattern(this.gitConnectorDescriptor.branchIncludePatterns, this.gitConnectorDescriptor.branchExcludePatterns).withBranchingEnabled(this.gitConnectorDescriptor.branchingEnabled).withStartRevision(this.gitConnectorDescriptor.getStartRevision()).withEndRevision(this.gitConnectorDescriptor.getEndRevision());
        return parameterBuilder.build();
    }

    private GitRepositoryConnectorParameterStep buildGitParameters(GitIndices gitIndices) throws StorageException {
        GitRepositoryConnectorParameterStep.GitRepositoryConnectorBuilder gitRepositoryConnectorBuilder = GitRepositoryConnectorParameterStep.builder(gitIndices, this.projectStorageSystem.openBranchingLayer(GitBranchPointerIndex.createIndexName(this.gitConnectorDescriptor.getRepositoryIdentifier()), GitBranchPointerIndex.class)).withImportantBranchPatterns(this.gitConnectorDescriptor.importantBranchPatterns).withCloneDirectory(this.cloneDirectory).withIsIncludeSubModules(this.gitConnectorDescriptor.isIncludeSubModules()).withSubModuleRecursionDepth(this.gitConnectorDescriptor.getSubModuleRecursionDepth()).withSshKeyIdentifier(this.gitConnectorDescriptor.getPrivateKeyId()).withUserRequestedRefSpecs(this.gitConnectorDescriptor.getUserRequestedRefSpecs());
        return gitRepositoryConnectorBuilder.build();
    }

    private GitIndices getIndices(ServerOptionIndex serverOptionIndex, GitRepositoryInfoIndex gitInfoIndex) throws StorageException {
        return new GitIndices(gitInfoIndex, serverOptionIndex, (AccessTokenIndex)this.globalStorageSystem.openGlobalIndex(AccessTokenIndex.class), (PostponedRollbackIndex)this.projectStorageSystem.openProjectIndex(PostponedRollbackIndex.class, null), (RepositoryRevisionIndex)this.projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null), (PendingGarbageCollectionIndex)this.globalStorageSystem.openGlobalIndex(PendingGarbageCollectionIndex.class), this.openCrossRepositoryMergeRequestSourceBranchesIndex());
    }

    private GitRepositoryInfoIndex openGitInfoIndex() throws StorageException {
        return (GitRepositoryInfoIndex)this.projectStorageSystem.openProjectIndex(GitRepositoryInfoIndex.class, GitRepositoryInfoIndex.createIndexName(this.gitConnectorDescriptor.getRepositoryIdentifier()), null);
    }

    private CrossRepositoryMergeRequestSourceBranchesIndex openCrossRepositoryMergeRequestSourceBranchesIndex() throws StorageException {
        return (CrossRepositoryMergeRequestSourceBranchesIndex)this.projectStorageSystem.openProjectIndex(CrossRepositoryMergeRequestSourceBranchesIndex.class, CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(this.gitConnectorDescriptor.getRepositoryIdentifier()), null);
    }
}

