/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.MergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.bitbucket.BitbucketUtils;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.lib.commons.collections.CollectionUtils;

public class BitbucketServerMergeRequestBuildJobHandler
extends MergeRequestBuildJobHandler<CommitStatus> {
    private final BitbucketServerClient client;

    public BitbucketServerMergeRequestBuildJobHandler(BitbucketServerClient client, IncludeExcludeRegexSupport buildIncludeExcludeRegexSupport) {
        super(buildIncludeExcludeRegexSupport);
        this.client = client;
    }

    @Override
    protected List<CommitStatus> getPlatformMergeRequestBuildJobs(String mergeRequestSourceHead) throws ServiceCallException {
        List<CommitStatus> commitStatuses = this.client.getCommitBuildStatuses(mergeRequestSourceHead);
        return CollectionUtils.filter(commitStatuses, commitStatus -> {
            String buildNameOrKey = Objects.requireNonNullElseGet(commitStatus.getName(), commitStatus::getKey);
            return !BitbucketUtils.TEAMSCALE_BUILD_KEYS.contains(commitStatus.getKey()) && this.buildIncludeExcludeRegexSupport.isIncluded(buildNameOrKey);
        });
    }
}

