/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server.client;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.repository.git.bitbucket.BitbucketInstallationRepositories;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerUtils;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerPagination;
import com.teamscale.index.repository.git.bitbucket.server.client.IBitbucketServerApi;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatuses;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightAnnotation;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightAnnotations;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightReport;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightReports;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequestDescription;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequests;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerReviewer;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.BitBucketServerPullRequestChanges;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerPullRequestDiffs;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerCodeStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerInlinePullRequestComment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestActivities;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestActivity;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestComments;
import com.teamscale.index.repository.git.bitbucket.server.model.web_hooks.BitbucketServerWebHook;
import com.teamscale.index.repository.git.bitbucket.server.model.web_hooks.BitbucketServerWebHooks;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class BitbucketServerClient {
    @VisibleForTesting
    public static final int PAGE_LIMIT = 10000;
    private static final Logger LOGGER = LogManager.getLogger();
    private final IBitbucketServerApi bitbucketServer;

    public BitbucketServerClient(String baseUrl, @Nullable String username, String password, Logger interactionLogger) {
        this.bitbucketServer = (IBitbucketServerApi)BitbucketServerClient.configureAuthenticationMode(Retrofit.builder((String)baseUrl), username, password).withInteractionLogger(interactionLogger).create(IBitbucketServerApi.class);
    }

    private static Retrofit.Builder configureAuthenticationMode(Retrofit.Builder builder, @Nullable String username, String passwordOrToken) {
        if (StringUtils.isEmpty((String)username)) {
            return builder.withBearerAuthentication(passwordOrToken);
        }
        return builder.withBasicNTLMAuthentication(username, passwordOrToken);
    }

    public BitbucketServerPullRequest getPullRequest(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        return (BitbucketServerPullRequest)Retrofit.executeServiceCall(this.bitbucketServer.getPullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId)).orElseThrow();
    }

    public String getHtmlPullRequestUrl(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) {
        return this.bitbucketServer.getPullRequest(repositoryIdentifier.getOwner().toUpperCase(), repositoryIdentifier.getRepo(), pullRequestId).request().url().toString().replace(StringUtils.ensureEndsWith((String)"rest/api/1.0", (String)"/"), "");
    }

    public List<BitbucketServerPullRequest> getOpenPullRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return ((BitbucketServerPullRequests)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getOpenPullRequests(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), 10000, (Long)pageStart, null, null))).getValues();
    }

    public List<BitbucketServerPullRequest> getOpenPullRequestsForSourceBranch(PlatformRepositoryIdentifier repositoryIdentifier, String sourceBranchRefId) throws ServiceCallException {
        return ((BitbucketServerPullRequests)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getOpenPullRequests(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), 10000, (Long)pageStart, "outgoing", sourceBranchRefId))).getValues();
    }

    public BitbucketInstallationRepositories.InstallationRepository getBitbucketRepository(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return this.bitbucketServer.getRepository(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo());
    }

    public List<BitbucketServerWebHook> getRepositoryWebHooks(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return ((BitbucketServerWebHooks)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getWebhooks(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), 10000, (Long)pageStart))).getValues();
    }

    public List<CommitStatus> getCommitBuildStatuses(String commitHash) throws ServiceCallException {
        return ((CommitStatuses)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getCommitBuildStatuses(commitHash, 10000, (Long)pageStart))).getValues();
    }

    public String getServerVersion() throws ServiceCallException {
        return this.bitbucketServer.getServerVersion().version();
    }

    public void createRepositoryWebHook(PlatformRepositoryIdentifier repositoryIdentifier, String webHookUrl, String[] webHookEvents) throws ServiceCallException {
        this.bitbucketServer.postWebHook(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), new BitbucketServerWebHook("Teamscale Web Hook", webHookUrl, webHookEvents, true));
    }

    public void updateRepositoryWebHook(PlatformRepositoryIdentifier repositoryIdentifier, int webhookId, String webHookUrl, String[] webHookEvents) throws ServiceCallException {
        this.bitbucketServer.putWebHook(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), webhookId, new BitbucketServerWebHook(webhookId, "Teamscale Web Hook", webHookUrl, webHookEvents, true));
    }

    public void postNewCommitStatus(PlatformRepositoryIdentifier repositoryIdentifier, CommitStatus status, String commit) throws ServiceCallException {
        this.bitbucketServer.postCommitStatus(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit, status);
    }

    public void postNewLegacyCommitStatus(CommitStatus status, String commit) throws ServiceCallException {
        this.bitbucketServer.postLegacyCommitStatus(commit, status);
    }

    public void putPullRequestDescription(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, int lastVersion, String newDescription, BitbucketServerReviewer[] reviewers) throws ServiceCallException {
        this.bitbucketServer.putPullRequestDescription(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, new BitbucketServerPullRequestDescription(pullRequestId, lastVersion, newDescription, reviewers));
    }

    public BitBucketServerPullRequestChanges getPullRequestChanges(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        LOGGER.traceEntry(null, new Object[]{repositoryIdentifier, pullRequestId});
        BitBucketServerPullRequestChanges bitBucketServerPullRequestChanges = (BitBucketServerPullRequestChanges)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getPullRequestChanges(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, 10000, (Long)pageStart));
        return (BitBucketServerPullRequestChanges)LOGGER.traceExit((Object)bitBucketServerPullRequestChanges);
    }

    public BitbucketServerPullRequestDiffs getPullRequestDiff(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        return this.bitbucketServer.getPullRequestDiff(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId);
    }

    public List<BitbucketServerPullRequestComment> getPullRequestCommentsForPath(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, String path) throws ServiceCallException {
        return ((BitbucketServerPullRequestComments)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getPullRequestCommentsForPath(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, 10000, (Long)pageStart, path))).getValues();
    }

    public List<BitbucketServerPullRequestComment> getPullRequestComments(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        List<BitbucketServerPullRequestActivity> pullRequestActivities = this.getPullRequestActivities(repositoryIdentifier, pullRequestId);
        List pullRequestComments = CollectionUtils.filter(pullRequestActivities, activity -> activity.action().equals("COMMENTED") && activity.comment() != null);
        return CollectionUtils.map((Collection)pullRequestComments, BitbucketServerPullRequestActivity::comment);
    }

    private List<BitbucketServerPullRequestActivity> getPullRequestActivities(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        return ((BitbucketServerPullRequestActivities)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getPullRequestActivities(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, 10000, (Long)pageStart))).getValues();
    }

    public void deletePullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, long commentId, long commentVersion) throws ServiceCallException {
        this.bitbucketServer.deletePullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, commentId, commentVersion);
    }

    public void postCodeInsightAnnotation(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, BitbucketServerCodeInsightAnnotation annotation, MergeRequest mergeRequest) throws ServiceCallException, UnsupportedEncodingException {
        String sourceCommit = mergeRequest.sourceHead;
        LOGGER.debug("Posting annotation on commit {} for pull request {} in {}: {}", (Object)sourceCommit, (Object)pullRequestId, (Object)repositoryIdentifier, (Object)annotation);
        this.bitbucketServer.postCodeInsightAnnotation(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), sourceCommit, new BitbucketServerCodeInsightAnnotations(annotation));
    }

    public void postInlinePullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, BitbucketServerInlinePullRequestComment comment) throws ServiceCallException, UnsupportedEncodingException {
        this.bitbucketServer.postInlinePullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, comment);
    }

    public @Nullable BitbucketServerCodeInsightReport getTeamscaleReport(PlatformRepositoryIdentifier repositoryIdentifier, String commitHash) throws ServiceCallException {
        return this.bitbucketServer.getTeamscaleCodeInsightReport(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commitHash);
    }

    public @Nullable BitbucketServerCodeInsightAnnotations getTeamscaleReportAnnotations(PlatformRepositoryIdentifier repositoryIdentifier, String commitHash) throws ServiceCallException {
        return this.bitbucketServer.getTeamscaleCodeInsightReportAnnotations(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commitHash);
    }

    public boolean hasTeamscaleReport(PlatformRepositoryIdentifier repositoryIdentifier, String commitHash) {
        try {
            return this.getTeamscaleReport(repositoryIdentifier, commitHash) != null;
        }
        catch (ServiceCallException e) {
            return false;
        }
    }

    public boolean hasForeignReport(PlatformRepositoryIdentifier repositoryIdentifier, String commitHash) throws ServiceCallException {
        return this.getCodeInsightReports(repositoryIdentifier, commitHash).stream().anyMatch(report -> !report.reporter().equals("Teamscale"));
    }

    private List<BitbucketServerCodeInsightReport> getCodeInsightReports(PlatformRepositoryIdentifier repositoryIdentifier, String commitHash) throws ServiceCallException {
        return ((BitbucketServerCodeInsightReports)BitbucketServerClient.executeWithPagination(pageStart -> this.bitbucketServer.getCodeInsightReports(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commitHash, 10000, (Long)pageStart))).getValues();
    }

    public void postConcludedReport(PlatformRepositoryIdentifier repositoryIdentifier, TeamscaleCommitLinkProvider linkProvider, MergeRequest mergeRequest, String reportDetails) throws ServiceCallException {
        String sourceCommit = mergeRequest.sourceHead;
        BitbucketServerCodeInsightReport.EResult result = BitbucketServerCodeInsightReport.EResult.PASS;
        this.bitbucketServer.putCodeInsightReport(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), sourceCommit, new BitbucketServerCodeInsightReport(reportDetails, (TeamscaleProjectLinkProvider)linkProvider, mergeRequest.identifier, result));
    }

    public void postAnalysisInProgressReport(String commit, TeamscaleProjectLinkProvider linkProvider, MergeRequestIdentifier mergeRequestIdentifier) throws ServiceCallException {
        PlatformRepositoryIdentifier repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(mergeRequestIdentifier.repositoryName);
        this.bitbucketServer.putCodeInsightReport(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit, new BitbucketServerCodeInsightReport(BitbucketServerUtils.getAnalysisInProgressText(commit), linkProvider, mergeRequestIdentifier, BitbucketServerCodeInsightReport.EResult.PASS));
    }

    public void postAnalysisSkippedReport(PlatformRepositoryIdentifier repositoryIdentifier, String commit, TeamscaleProjectLinkProvider linkProvider, MergeRequestIdentifier mergeRequestIdentifier, String reason) throws ServiceCallException {
        this.bitbucketServer.putCodeInsightReport(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit, new BitbucketServerCodeInsightReport("Teamscale analysis for commit %s was skipped: %s".formatted(commit, reason), linkProvider, mergeRequestIdentifier, BitbucketServerCodeInsightReport.EResult.PASS));
    }

    public void postAnalysisErrorReport(PlatformRepositoryIdentifier repositoryIdentifier, String commit, TeamscaleProjectLinkProvider linkProvider, MergeRequestIdentifier mergeRequestIdentifier, String reason) throws ServiceCallException {
        this.bitbucketServer.putCodeInsightReport(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit, new BitbucketServerCodeInsightReport("Teamscale analysis for commit %s encountered an error: %s".formatted(commit, reason), linkProvider, mergeRequestIdentifier, BitbucketServerCodeInsightReport.EResult.PASS));
    }

    public void deleteTeamscaleReport(PlatformRepositoryIdentifier repositoryIdentifier, String commitHash) throws ServiceCallException {
        this.bitbucketServer.deleteCodeInsightReport(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commitHash);
    }

    public void postGeneralPullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, BitbucketServerPullRequestComment comment) throws ServiceCallException {
        this.bitbucketServer.postPullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, comment);
    }

    public void updateInlinePullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, long commentId, BitbucketServerPullRequestComment updatedComment) throws ServiceCallException {
        this.bitbucketServer.putPullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, commentId, updatedComment);
    }

    public void putPullRequestReview(PlatformRepositoryIdentifier repositoryName, long pullRequestId, String userSlug, BitbucketServerCodeStatus codeStatus) throws ServiceCallException {
        this.bitbucketServer.putPullRequestReviewStatus(repositoryName.getOwner(), repositoryName.getRepo(), pullRequestId, userSlug, codeStatus);
    }

    private static <T extends BitbucketServerPagination<S>, S> T executeWithPagination(FunctionWithException<Long, T, ServiceCallException> createCallWithStartParameter) throws ServiceCallException {
        BitbucketServerPagination dataObject = (BitbucketServerPagination)createCallWithStartParameter.apply(null);
        ArrayList result = new ArrayList(dataObject.getValues());
        while (dataObject.hasNextPage()) {
            dataObject = (BitbucketServerPagination)createCallWithStartParameter.apply((Object)dataObject.getNextPageStart());
            result.addAll(dataObject.getValues());
        }
        dataObject.setValues(result);
        return (T)dataObject;
    }
}

