/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common.merge_request_statistics;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestTestGapInfo;
import com.teamscale.index.merge_request.testcoverage.MergeRequestLineCoverageCalculator;
import com.teamscale.index.merge_request.testcoverage.TestCoverageDeltaInfo;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.assessment.context.MetricEvaluationContext;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.common.merge_request_statistics.IMergeRequestStatisticsCollector;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MergeRequestStatisticsCollector
implements IMergeRequestStatisticsCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"merge-request-statistics");
    private static final EnumSet<VotingException.Skipped.Reason> SKIPPED_REASONS_TO_LOG = EnumSet.of(VotingException.Skipped.Reason.SHADOW_MODE_ENABLED, VotingException.Skipped.Reason.INTEGRATION_DISABLED);
    private static final long LOG_SCHEMA_VERSION = 1L;
    public static final String CSV_DELIMITER = ";";
    private static final String LIST_VALUE_DELIMITER = "|";
    private static final String NOT_AVAILABLE = "N/A";
    private static final String COVERAGE_OF_CHANGES_STATISTIC_NAME = "Coverage of changes";
    private static final String TGA_STATISTIC_NAME = "TGA";
    private static @Nullable Consumer<Object[]> rowConsumerForTesting;
    private final PublicProjectId publicProjectId;
    private final MergeRequestAnnotationInput votingInput;
    private final GlobalStorageSystem globalStorage;
    private final ProjectStorageSystem projectStorage;
    private final IndexLayer indexLayer;

    MergeRequestStatisticsCollector(IndexLayer indexLayer, InternalProjectId projectId, MergeRequestAnnotationInput votingInput) throws StorageException {
        Preconditions.checkState((boolean)MergeRequestStatisticsCollector.isEnabled(), (Object)"This class should only be instantiated when enabled. This is a programming error. Use IMergeRequestStatisticsCollector#create instead.");
        this.publicProjectId = indexLayer.resolveToPrimaryPublicProjectId((IProjectId)projectId);
        this.votingInput = votingInput;
        this.globalStorage = indexLayer.openGlobalStorageSystem();
        this.projectStorage = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        this.indexLayer = indexLayer;
    }

    static boolean isEnabled() {
        return LOGGER.isEnabled(Level.TRACE, MARKER) || rowConsumerForTesting != null;
    }

    @Override
    public void logVotingException(VotingException exception) throws StorageException {
        if (!(exception instanceof VotingException.Skipped)) {
            LOGGER.debug("Skipping merge request statistics log because a voting error occurred.", (Throwable)exception);
            return;
        }
        VotingException.Skipped skip = (VotingException.Skipped)exception;
        if (!SKIPPED_REASONS_TO_LOG.contains((Object)skip.getReason())) {
            LOGGER.debug("Skipping merge request statistics log because the vote was skipped with '{}'.", (Object)skip.getReason());
            return;
        }
        this.logVote(exception.getRecord().getState());
    }

    @Override
    public void logVote(VotingRecord.EVotingState votingState) throws StorageException {
        long voteTimestamp = DateTimeUtils.millisNow();
        String mrCommitType = MergeRequestStatisticsCollector.getMergeRequestCommitType();
        RepositoryLogEntryAggregate logEntry = this.getRepositoryLogEntry();
        String commitTypes = MergeRequestStatisticsCollector.getCommitTypes(logEntry);
        String commitHash = MergeRequestStatisticsCollector.getCommitHash(logEntry);
        String affectedIssues = this.getAffectedIssuesStatistic();
        for (MergeRequestStatistic statistic : this.collectStatistics()) {
            MergeRequestStatisticsCollector.logRow(new Object[]{1L, this.publicProjectId, this.votingInput.mergeRequest.identifier.repositoryName, this.votingInput.mergeRequest.identifier.id, this.votingInput.mergeRequest.status, votingState, mrCommitType, this.votingInput.sourceCommit.getTimestamp(), commitTypes, commitHash, voteTimestamp, statistic.name(), statistic.value(), statistic.valueChange(), affectedIssues});
        }
    }

    private Iterable<MergeRequestStatistic> collectStatistics() throws StorageException {
        ArrayList<MergeRequestStatistic> statistics = new ArrayList<MergeRequestStatistic>();
        statistics.add(this.getFindingsStatistic());
        statistics.add(this.getTgaStatisticFailSafe());
        statistics.add(this.getCoverageOfChangesStatisticFailSafe());
        statistics.addAll(this.getMetricStatistics(EMetricSchemaSource.CODE_METRICS));
        statistics.addAll(this.getMetricStatistics(EMetricSchemaSource.NON_CODE_METRICS));
        statistics.addAll(this.getMetricBadgeStatistics());
        return statistics;
    }

    private @Nullable RepositoryLogEntryAggregate getRepositoryLogEntry() throws StorageException {
        return (RepositoryLogEntryAggregate)((RepositoryLogIndex)this.projectStorage.openProjectIndex(RepositoryLogIndex.class, null)).getEntry(this.votingInput.sourceCommit);
    }

    private Collection<MergeRequestStatistic> getMetricBadgeStatistics() {
        LOGGER.traceEntry("Collecting metric badge statistics.", new Supplier[0]);
        Set evaluatedMetrics = this.votingInput.metricThresholdsInfo.evaluatedMetricGroups().stream().flatMap(evaluatedGroup -> evaluatedGroup.getIndividualMetricEvaluationResults().stream()).collect(Collectors.toSet());
        evaluatedMetrics.addAll(this.votingInput.metricThresholdsInfo.evaluatedMetrics());
        return (Collection)LOGGER.traceExit(evaluatedMetrics.stream().map(evaluatedMetric -> new MergeRequestStatistic(evaluatedMetric.getName(), evaluatedMetric.getFormattedMetricValue().orElse(NOT_AVAILABLE), evaluatedMetric.getFormattedMetricDelta().orElse(NOT_AVAILABLE))).toList());
    }

    private Collection<MergeRequestStatistic> getMetricStatistics(EMetricSchemaSource schemaSource) throws StorageException {
        LOGGER.traceEntry("Collecting metric statistics for schema source {}.", new Object[]{schemaSource});
        MetricSchemaRetrieverFactory metricSchemaRetrieverFactory = new MetricSchemaRetrieverFactory(this.projectStorage);
        MetricDataRetrieverFactory metricDataRetrieverFactory = new MetricDataRetrieverFactory(this.projectStorage, this.globalStorage, null, metricSchemaRetrieverFactory);
        UnmodifiableList metricSchemas = MetricRetrievalStrategyFactory.getStrategy(schemaSource.getPathType(), this.projectStorage, this.globalStorage, null, metricSchemaRetrieverFactory).getMetricDirectorySchema().getAllEntries();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> metricSchemas.size();
        supplierArray[1] = () -> schemaSource.name();
        supplierArray[2] = () -> metricSchemas.stream().map(MetricDirectorySchemaEntry::getName).collect(Collectors.joining(","));
        LOGGER.debug("Found {} metric entries for schema source {}: {}", supplierArray);
        ArrayList<MergeRequestStatistic> statistics = new ArrayList<MergeRequestStatistic>();
        for (MetricDirectorySchemaEntry metricSchema : metricSchemas) {
            MetricEvaluationContext evaluationContext = new MetricEvaluationContext("", metricDataRetrieverFactory);
            MetricValueBase<?> headValue = MergeRequestStatisticsCollector.getMetricValue(metricSchema, evaluationContext, schemaSource, this.votingInput.sourceCommit);
            MetricValueBase<?> baseValue = MergeRequestStatisticsCollector.getMetricValue(metricSchema, evaluationContext, schemaSource, this.votingInput.mergeBase.getMergeBase());
            String valueChange = MergeRequestStatisticsCollector.calculateValueChange(headValue, baseValue);
            Supplier[] supplierArray2 = new Supplier[4];
            supplierArray2[0] = () -> ((MetricDirectorySchemaEntry)metricSchema).getName();
            supplierArray2[1] = headValue::toString;
            supplierArray2[2] = baseValue::toString;
            supplierArray2[3] = valueChange::toString;
            LOGGER.debug("Collected metric '{}' with head value '{}', base value '{}', and value change '{}'.", supplierArray2);
            statistics.add(new MergeRequestStatistic(metricSchema.getName(), ((Serializable)((Object)Objects.requireNonNullElse(headValue.getOrNull(), NOT_AVAILABLE))).toString(), valueChange));
        }
        return (Collection)LOGGER.traceExit(statistics);
    }

    private static MetricValueBase<?> getMetricValue(MetricDirectorySchemaEntry metricSchema, MetricEvaluationContext evaluationContext, EMetricSchemaSource schemaSource, CommitDescriptor commit) throws StorageException {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((MetricDirectorySchemaEntry)metricSchema).getName();
        supplierArray[1] = () -> schemaSource.name();
        LOGGER.traceEntry("Reading metric value for {} with schema source {}.", supplierArray);
        MetricValueBase metricValue = MetricValueBase.createWithOptional((MetricDirectorySchemaEntry)metricSchema, evaluationContext.getMetricValue(metricSchema.getName(), "", schemaSource, HistoryAccessOption.readCommit((CommitDescriptor)commit)));
        Supplier[] supplierArray2 = new Supplier[4];
        supplierArray2[0] = () -> ((MetricDirectorySchemaEntry)metricSchema).getName();
        supplierArray2[1] = () -> schemaSource.name();
        supplierArray2[2] = () -> ((CommitDescriptor)commit).toString();
        supplierArray2[3] = () -> ((MetricValueBase)metricValue).getOrNull();
        LOGGER.trace("Metric value for {} with schema source {} at commit {} is '{}'.", supplierArray2);
        return (MetricValueBase)LOGGER.traceExit((Object)metricValue);
    }

    private static String getMergeRequestCommitType() {
        LOGGER.traceEntry("Collecting merge request commit type.", new Supplier[0]);
        return (String)LOGGER.traceExit((Object)NOT_AVAILABLE);
    }

    private static String getCommitTypes(@Nullable RepositoryLogEntryAggregate entry) {
        LOGGER.traceEntry("Collecting commit types for entry {}.", new Object[]{entry});
        if (entry == null) {
            return (String)LOGGER.traceExit((Object)NOT_AVAILABLE);
        }
        return (String)LOGGER.traceExit((Object)entry.getCommitTypes().stream().map(Enum::name).sorted().collect(Collectors.joining(LIST_VALUE_DELIMITER)));
    }

    private static String getCommitHash(@Nullable RepositoryLogEntryAggregate entry) {
        LOGGER.traceEntry("Collecting commit hash for entry {}.", new Object[]{entry});
        if (entry == null) {
            return (String)LOGGER.traceExit((Object)NOT_AVAILABLE);
        }
        return (String)LOGGER.traceExit((Object)entry.getPrimaryEntry().getRevision());
    }

    private MergeRequestStatistic getCoverageOfChangesStatisticFailSafe() {
        try {
            return this.getCoverageOfChangesStatistic();
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred while collecting coverage of changes statistic.", (Throwable)e);
            return new MergeRequestStatistic(COVERAGE_OF_CHANGES_STATISTIC_NAME, NOT_AVAILABLE, NOT_AVAILABLE);
        }
    }

    private MergeRequestStatistic getCoverageOfChangesStatistic() {
        LOGGER.traceEntry("Collecting coverage of changes statistic.", new Supplier[0]);
        TestCoverageDeltaInfo coverageInfo = this.votingInput.testCoverageDeltaInfo;
        if (coverageInfo == null) {
            LOGGER.debug("Test coverage delta info is not available. Calculating it.");
            try {
                coverageInfo = MergeRequestLineCoverageCalculator.getLineCoverageDelta(this.projectStorage, this.votingInput.sourceCommit, this.votingInput.mergeBase, this.votingInput.mergeRequest.identifier);
            }
            catch (StorageException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to calculate test coverage delta info.");
                return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic(COVERAGE_OF_CHANGES_STATISTIC_NAME, NOT_AVAILABLE, NOT_AVAILABLE));
            }
        }
        if (!coverageInfo.hasTestCoveragePartitions()) {
            LOGGER.debug("The project has no test coverage partitions.");
            return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic(COVERAGE_OF_CHANGES_STATISTIC_NAME, NOT_AVAILABLE, NOT_AVAILABLE));
        }
        if (coverageInfo.lineCoverageChanges().isEmpty()) {
            LOGGER.debug("No added or changed code found in this merge request.");
            return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic(COVERAGE_OF_CHANGES_STATISTIC_NAME, NOT_AVAILABLE, NOT_AVAILABLE));
        }
        if (coverageInfo.updatedPartitions().isEmpty()) {
            LOGGER.debug("No test coverage partitions have been updated for the latest commit in this merge request. Still computing coverage of changes with potentially outdated data.");
        }
        LineCoverageVotingInfo lineCoverageVotingInfo = VotingConnectorUtils.computeLineCoverageVotingInfoWithoutRequirementsCheck(coverageInfo, this.votingInput.mergeRequest.identifier);
        return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic(COVERAGE_OF_CHANGES_STATISTIC_NAME, NOT_AVAILABLE, String.format("%.3f", lineCoverageVotingInfo.getCoverage())));
    }

    private MergeRequestStatistic getFindingsStatistic() {
        LOGGER.traceEntry("Collecting findings statistic.", new Supplier[0]);
        return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic("Findings", Integer.toString(this.votingInput.getRelevantFindingsDelta().getAllFindings().size()), Stream.of(this.votingInput.getRelevantFindingsDelta().getNumberOfAddedFindings(), this.votingInput.getRelevantFindingsDelta().getNumberOfFindingsInChangedCode(), this.votingInput.getRelevantFindingsDelta().getNumberOfRemovedFindings()).map(Object::toString).collect(Collectors.joining(LIST_VALUE_DELIMITER))));
    }

    private MergeRequestStatistic getTgaStatisticFailSafe() {
        try {
            return this.getTgaStatistic();
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred while collecting TGA statistic.", (Throwable)e);
            return new MergeRequestStatistic(TGA_STATISTIC_NAME, NOT_AVAILABLE, NOT_AVAILABLE);
        }
    }

    private MergeRequestStatistic getTgaStatistic() {
        LOGGER.traceEntry("Collecting TGA statistic.", new Supplier[0]);
        MergeRequestTestGapInfo testGapInfo = this.votingInput.testGapInfo;
        if (testGapInfo == null) {
            LOGGER.debug("Test gap info is not available. Calculating it.");
            try {
                testGapInfo = TgaRequestUtils.calculateTestGapsForMergeRequest(this.votingInput.sourceCommit, this.votingInput.mergeRequest.identifier, this.votingInput.mergeBase, this.indexLayer, (IProjectId)this.publicProjectId);
            }
            catch (BranchPointNotFoundException | StorageException e) {
                LOGGER.atError().withThrowable(e).log("Failed to calculate test gap info.");
                return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic(TGA_STATISTIC_NAME, NOT_AVAILABLE, NOT_AVAILABLE));
            }
        }
        CounterSet<ETestGapState> testGapStates = testGapInfo.testGapStates();
        return (MergeRequestStatistic)LOGGER.traceExit((Object)new MergeRequestStatistic(TGA_STATISTIC_NAME, NOT_AVAILABLE, Stream.of(testGapStates.getValue((Object)ETestGapState.TESTED_CHURN), testGapStates.getValue((Object)ETestGapState.UNTESTED_CHANGE), testGapStates.getValue((Object)ETestGapState.UNTESTED_ADDITION)).map(Object::toString).collect(Collectors.joining(LIST_VALUE_DELIMITER))));
    }

    private String getAffectedIssuesStatistic() throws StorageException {
        CommitDescriptor sourceCommit = this.votingInput.sourceCommit;
        LOGGER.traceEntry("Collecting affected issues statistic for commit {}.", new Object[]{sourceCommit});
        List<TeamscaleIssueId> issuesForCommit = ((RepositoryCommitIssueMappingIndex)this.projectStorage.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null)).getIssuesForCommit(sourceCommit);
        if (issuesForCommit == null || issuesForCommit.isEmpty()) {
            return (String)LOGGER.traceExit((Object)NOT_AVAILABLE);
        }
        return issuesForCommit.stream().map(TeamscaleIssueId::getExternalId).collect(Collectors.joining(LIST_VALUE_DELIMITER));
    }

    private static String calculateValueChange(MetricValueBase<?> headValue, MetricValueBase<?> baseValue) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> headValue.getOrNull();
        supplierArray[1] = () -> baseValue.getOrNull();
        LOGGER.traceEntry("Calculating value change between head value {} and base value {}.", supplierArray);
        return (String)LOGGER.traceExit((Object)headValue.getDelta(baseValue).map(IMetricValue::getOrNull).map(Object::toString).orElse(NOT_AVAILABLE));
    }

    private static void logRow(Object ... entries) {
        LOGGER.trace(MARKER, Arrays.stream(entries).map(Object::toString).collect(Collectors.joining(CSV_DELIMITER)));
        if (rowConsumerForTesting != null) {
            rowConsumerForTesting.accept(entries);
        }
    }

    @TestOnly
    public static AutoCloseable setRowConsumerForTesting(@NonNull Consumer<Object[]> consumer) {
        if (rowConsumerForTesting != null) {
            throw new IllegalStateException("Row consumer for testing is already set.");
        }
        rowConsumerForTesting = consumer;
        return () -> {
            rowConsumerForTesting = null;
        };
    }

    private record MergeRequestStatistic(String name, String value, String valueChange) {
    }
}

