/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.comments.comments.CommitAlertReviewComment;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.git.gerrit.data.CommentRange;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class CommentInput {
    private static final String PATH_PROPERTY = "path";
    private static final String MESSAGE_PROPERTY = "message";
    private static final String RANGE_PROPERTY = "range";
    private static final String UNRESOLVED_PROPERTY = "unresolved";
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="range")
    private final CommentRange range;
    @JsonProperty(value="unresolved")
    private final boolean unresolved;

    @JsonCreator
    public CommentInput(@JsonProperty(value="path") String path, @JsonProperty(value="message") String message, @JsonProperty(value="range") CommentRange range, @JsonProperty(value="unresolved") boolean unresolved) {
        this.path = path;
        this.message = message;
        this.range = range;
        this.unresolved = unresolved;
    }

    public CommentInput(IReviewComment reviewComment) {
        this(reviewComment.getLocation().getUniformPath(), CommentInput.createMessage(reviewComment), new CommentRange(reviewComment.getStartLine()), true);
    }

    private static String createMessage(IReviewComment reviewComment) {
        StringBuilder sb = new StringBuilder();
        if (reviewComment instanceof CommitAlertReviewComment) {
            sb.appendCodePoint(10071);
        } else if (reviewComment.getAssessment() == ETrafficLightColor.YELLOW) {
            sb.appendCodePoint(9888);
        } else if (reviewComment.getAssessment() == ETrafficLightColor.RED) {
            sb.appendCodePoint(9940);
        }
        sb.append(" ").append(reviewComment.getText());
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }
}

