/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.MergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRunBuilder;
import com.teamscale.index.repository.git.github.data.GitHubBuildJob;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GitHubMergeRequestBuildJobHandler
extends MergeRequestBuildJobHandler<GitHubBuildJob> {
    private final PlatformRepositoryIdentifier repositoryIdentifier;
    private final String contextIdentifier;
    private final GitHubPullRequestClient client;

    public GitHubMergeRequestBuildJobHandler(GitHubPullRequestClient client, IncludeExcludeRegexSupport buildIncludeExcludeRegexSupport, PlatformRepositoryIdentifier repositoryIdentifier, String contextIdentifier) {
        super(buildIncludeExcludeRegexSupport);
        this.repositoryIdentifier = repositoryIdentifier;
        this.contextIdentifier = contextIdentifier;
        this.client = client;
    }

    @Override
    protected List<GitHubBuildJob> getPlatformMergeRequestBuildJobs(String mergeRequestSourceHead) throws ServiceCallException {
        ArrayList<GitHubBuildJob> allBuildJobs = new ArrayList<GitHubBuildJob>();
        allBuildJobs.addAll(this.getMatchingCheckRuns(mergeRequestSourceHead));
        allBuildJobs.addAll(this.getMatchingCommitStatuses(mergeRequestSourceHead));
        return allBuildJobs;
    }

    private List<GitHubBuildJob> getMatchingCheckRuns(String mergeRequestSourceHead) throws ServiceCallException {
        List<CheckRun> allCheckRuns = this.client.getCheckRuns(this.repositoryIdentifier, mergeRequestSourceHead);
        Set<String> teamscaleCheckRunNames = CheckRunBuilder.getTeamscaleCheckRunNames(this.contextIdentifier);
        List matchingCheckRuns = CollectionUtils.filter(allCheckRuns, checkRun -> !teamscaleCheckRunNames.contains(checkRun.name()) && this.buildIncludeExcludeRegexSupport.isIncluded(checkRun.name()));
        return CollectionUtils.map((Collection)matchingCheckRuns, checkRun -> GitHubBuildJob.fromCheckRun(checkRun, LogManager.getLogger()));
    }

    private Collection<GitHubBuildJob> getMatchingCommitStatuses(String mergeRequestSourceHead) throws ServiceCallException {
        List<GitHubCommitStatus> allCommitStatuses = this.client.getCommitStatuses(this.repositoryIdentifier, mergeRequestSourceHead);
        return allCommitStatuses.stream().filter(commitStatus -> this.buildIncludeExcludeRegexSupport.isIncluded(commitStatus.context())).map(GitHubBuildJob::new).toList();
    }
}

