/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestBuildStatus;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.GitLabCrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import java.time.Instant;
import java.util.List;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GitLabMergeRequestProvider
extends MergeRequestProvider<GitLabMergeRequest, GitLabCommitStatus> {
    private static final String STATUS_OPEN = "opened";
    private static final String STATUS_MERGED = "merged";
    private final String repositoryName;
    private final GitLabClient client;

    public GitLabMergeRequestProvider(String repositoryName, GitLabClient client, IncludeExcludeRegexSupport buildIncludeExcludeRegexSupport) {
        super(new GitLabCrossRepositoryMergeRequestHandler(), new GitLabMergeRequestBuildJobHandler(client, repositoryName, buildIncludeExcludeRegexSupport));
        this.repositoryName = repositoryName;
        this.client = client;
    }

    @Override
    protected List<GitLabMergeRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        return this.client.listOpenMergeRequests(this.repositoryName);
    }

    @Override
    public @Nullable GitLabMergeRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        try {
            return this.client.getMergeRequest(this.repositoryName, id);
        }
        catch (ServiceCallException sce) {
            if (GitLabMergeRequestProvider.wasMergeRequestDeleted(sce)) {
                return null;
            }
            throw sce;
        }
    }

    private static boolean wasMergeRequestDeleted(ServiceCallException sce) {
        return sce.getMessage().contains("{\"message\":\"404 Not found\"}");
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(GitLabMergeRequest mergeRequest) {
        return new GitLabMergeRequestAdapter(mergeRequest);
    }

    @Override
    protected MergeRequestProvider.IMergeRequestBuildJobAdapter createMergeRequestBuildJobAdapter(GitLabCommitStatus commitStatus) {
        return new GitLabBuildJobAdapter(commitStatus);
    }

    @Override
    public boolean isMergeRequestSupported(@NonNull GitLabMergeRequest gitLabMergeRequest) throws ServiceCallException {
        return super.isMergeRequestSupported(gitLabMergeRequest) && !GitLabMergeRequestProvider.isIncompleteMergeRequest(gitLabMergeRequest);
    }

    private static boolean isIncompleteMergeRequest(@NonNull GitLabMergeRequest gitLabMergeRequest) {
        return StringUtils.isEmpty((String)gitLabMergeRequest.sha()) || StringUtils.isEmpty((String)gitLabMergeRequest.targetBranch());
    }

    @Override
    public boolean isCrossRepositoryMergeRequest(@NonNull GitLabMergeRequest mergeRequest) {
        return GitLabCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest(mergeRequest);
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    private class GitLabMergeRequestAdapter
    implements MergeRequestProvider.IMergeRequestAdapter {
        private final GitLabMergeRequest mergeRequest;

        private GitLabMergeRequestAdapter(GitLabMergeRequest mergeRequest) {
            this.mergeRequest = mergeRequest;
        }

        @Override
        public MergeRequestIdentifier getIdentifier() {
            return new MergeRequestIdentifier(GitLabMergeRequestProvider.this.repositoryName, (long)this.mergeRequest.id());
        }

        @Override
        public EMergeRequestStatus getStatus() {
            return switch (this.mergeRequest.state()) {
                case GitLabMergeRequestProvider.STATUS_OPEN -> EMergeRequestStatus.OPEN;
                case GitLabMergeRequestProvider.STATUS_MERGED -> EMergeRequestStatus.MERGED;
                default -> EMergeRequestStatus.OTHER;
            };
        }

        @Override
        public String getTitle() {
            return this.mergeRequest.title();
        }

        @Override
        public String getSourceBranch() {
            return this.mergeRequest.sourceBranch();
        }

        @Override
        public String getCommit() {
            return this.mergeRequest.sha();
        }

        @Override
        public String getTargetBranch() {
            return this.mergeRequest.targetBranch();
        }

        @Override
        public String getUrl() {
            return GitLabMergeRequestProvider.this.client.getMergeRequestUrl(GitLabMergeRequestProvider.this.repositoryName, this.mergeRequest.id());
        }

        @Override
        public Long getCreatedAt() {
            return Instant.parse(this.mergeRequest.createdAt()).toEpochMilli();
        }

        @Override
        public Long getUpdatedAt() {
            return Instant.parse(this.mergeRequest.updatedAt()).toEpochMilli();
        }
    }

    private record GitLabBuildJobAdapter(GitLabCommitStatus commitStatus) implements MergeRequestProvider.IMergeRequestBuildJobAdapter
    {
        @Override
        public EMergeRequestBuildStatus getStatus() {
            return switch (this.commitStatus.status()) {
                case "success", "failed", "warning", "canceled", "skipped" -> EMergeRequestBuildStatus.COMPLETED;
                case "manual" -> EMergeRequestBuildStatus.COMPLETED;
                case "running", "pending", "created", "scheduled" -> EMergeRequestBuildStatus.IN_PROGRESS;
                default -> EMergeRequestBuildStatus.UNKNOWN;
            };
        }

        @Override
        public @NonNull String getName() {
            return this.commitStatus().name();
        }
    }
}

