/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.retrievers;

import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.repository.git.GitCommitMessagesRetriever;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitCommitMessagesRetriever;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudDataRetriever;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerCommitMessagesRetriever;
import com.teamscale.index.repository.git.gerrit.GerritCommitMessagesRetriever;
import com.teamscale.index.repository.git.github.GitHubDataRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabCommitMessagesRetriever;
import com.teamscale.index.repository.git.scm_manager.ScmManagerCommitMessagesRetriever;
import com.teamscale.index.repository.retrievers.ICommitMessagesRetriever;
import com.teamscale.index.repository.sap.abapsystem.AbapCommitMessagesRetriever;
import com.teamscale.index.repository.svn.SVNCommitMessageRetriever;
import com.teamscale.index.repository.tfs.TfsCommitMessagesRetriever;
import jakarta.ws.rs.BadRequestException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class CommitMessagesRetrieverFactory {
    private static final Map<ERepositoryConnector, CommitMessagesRetrieverInitializer> SUPPORTED_SYSTEMS = Map.ofEntries(Map.entry(ERepositoryConnector.ABAP_GIT, AbapCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.AZURE_DEVOPS_GIT, AzureDevOpsGitCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.BITBUCKET, BitbucketCloudDataRetriever::new), Map.entry(ERepositoryConnector.BITBUCKET_SERVER, BitbucketServerCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.GERRIT, GerritCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.GIT, GitCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.GITHUB, GitHubDataRetriever::new), Map.entry(ERepositoryConnector.GITLAB, GitLabCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.SCM_MANAGER, ScmManagerCommitMessagesRetriever::new), Map.entry(ERepositoryConnector.SVN, (globalStorageSystem, logger) -> new SVNCommitMessageRetriever()), Map.entry(ERepositoryConnector.TFS, (globalStorageSystem, logger) -> new TfsCommitMessagesRetriever()));

    public static ICommitMessagesRetriever getCommitMessagesRetriever(ERepositoryConnector repositoryConnector, GlobalStorageSystem storageSystem, Logger interactionLogger) throws StorageException {
        CommitMessagesRetrieverInitializer commitMessagesRetrieverInitializer = SUPPORTED_SYSTEMS.get(repositoryConnector);
        if (commitMessagesRetrieverInitializer == null) {
            throw new BadRequestException("Unsupported Version Control System: " + repositoryConnector.getReadableName() + "\n  Current supported Version Control Systems: " + CommitMessagesRetrieverFactory.listSupportedSystems());
        }
        return commitMessagesRetrieverInitializer.init(storageSystem, interactionLogger);
    }

    private static String listSupportedSystems() {
        return SUPPORTED_SYSTEMS.keySet().stream().map(ERepositoryConnector::getReadableName).collect(Collectors.joining(", "));
    }

    @FunctionalInterface
    private static interface CommitMessagesRetrieverInitializer {
        public ICommitMessagesRetriever init(GlobalStorageSystem var1, Logger var2) throws StorageException;
    }
}

