/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.issue_reference.IssueReferenceIndex;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.wia.SpecItem;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class MergeRequestImpactedSpecItemsCalculatorIndexes {
    private final CommitDescriptor sourceBranchHead;
    private final MergeBaseInfo mergeBaseInfo;
    private final Set<CommitDescriptor> ancestorsOfSource = new HashSet<CommitDescriptor>();
    private final ProjectStorageSystem projectStorageSystem;
    private final GlobalStorageSystem globalStorageSystem;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private IssueReferenceIndex issueReferenceIndexAtSourceHead;
    private IssueReferenceIndex issueReferenceIndexAtMergeBase;
    private SpecItemCodeReferenceIndex specItemCodeReferenceIndexAtSourceHead;
    private SpecItemCodeReferenceIndex specItemCodeReferenceIndexAtMergeBase;
    private TokenElementIndex tokenElementIndexAtSourceHead;
    private TokenElementIndex tokenElementIndexAtMergeBase;
    private WorkItemHistoryIndexAggregation<SpecItem> specItemHistoryIndex;
    private RepositoryLogIndex repositoryLogIndex;
    private RepositoryLogFileIndex repositoryLogFileIndex;
    private HistoryAccessOption historyAccessOptionAtSourceHead;

    public MergeRequestImpactedSpecItemsCalculatorIndexes(CommitDescriptor sourceBranchHead, MergeBaseInfo mergeBaseInfo, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        this.sourceBranchHead = sourceBranchHead;
        this.mergeBaseInfo = mergeBaseInfo;
        this.parallelTaskExecutor = parallelTaskExecutor;
        for (ParentedCommitDescriptor parentedCommitDescriptor : mergeBaseInfo.getAncestorsOfSource()) {
            this.ancestorsOfSource.add(new CommitDescriptor(parentedCommitDescriptor.getBranchName(), parentedCommitDescriptor.getTimestamp()));
        }
        this.projectStorageSystem = projectStorageSystem;
        this.globalStorageSystem = globalStorageSystem;
        this.openIndexes();
    }

    private void openIndexes() throws StorageException {
        this.historyAccessOptionAtSourceHead = HistoryAccessOption.readCommit((CommitDescriptor)this.sourceBranchHead);
        HistoryAccessOption historyAccessOptionAtMergeBase = HistoryAccessOption.readCommit((CommitDescriptor)this.mergeBaseInfo.getMergeBase());
        this.specItemCodeReferenceIndexAtSourceHead = (SpecItemCodeReferenceIndex)this.projectStorageSystem.openProjectIndex(SpecItemCodeReferenceIndex.class, this.historyAccessOptionAtSourceHead);
        this.specItemCodeReferenceIndexAtMergeBase = (SpecItemCodeReferenceIndex)this.projectStorageSystem.openProjectIndex(SpecItemCodeReferenceIndex.class, historyAccessOptionAtMergeBase);
        this.issueReferenceIndexAtSourceHead = (IssueReferenceIndex)this.projectStorageSystem.openProjectIndex(IssueReferenceIndex.class, this.historyAccessOptionAtSourceHead);
        this.issueReferenceIndexAtMergeBase = (IssueReferenceIndex)this.projectStorageSystem.openProjectIndex(IssueReferenceIndex.class, historyAccessOptionAtMergeBase);
        this.tokenElementIndexAtSourceHead = (TokenElementIndex)this.projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", this.historyAccessOptionAtSourceHead);
        this.tokenElementIndexAtMergeBase = (TokenElementIndex)this.projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", historyAccessOptionAtMergeBase);
        this.specItemHistoryIndex = WorkItemHistoryIndexAggregation.forSpecItems(this.projectStorageSystem, this.historyAccessOptionAtSourceHead);
        this.repositoryLogIndex = (RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        this.repositoryLogFileIndex = (RepositoryLogFileIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogFileIndex.class, null);
    }

    public IssueReferenceIndex getIssueReferenceIndexAtSourceHead() {
        return this.issueReferenceIndexAtSourceHead;
    }

    public IssueReferenceIndex getIssueReferenceIndexAtMergeBase() {
        return this.issueReferenceIndexAtMergeBase;
    }

    public SpecItemCodeReferenceIndex getSpecItemCodeReferenceIndexAtSourceHead() {
        return this.specItemCodeReferenceIndexAtSourceHead;
    }

    public SpecItemCodeReferenceIndex getSpecItemCodeReferenceIndexAtMergeBase() {
        return this.specItemCodeReferenceIndexAtMergeBase;
    }

    public TokenElementIndex getTokenElementIndexAtSourceHead() {
        return this.tokenElementIndexAtSourceHead;
    }

    public TokenElementIndex getTokenElementIndexAtMergeBase() {
        return this.tokenElementIndexAtMergeBase;
    }

    public RepositoryLogIndex getRepositoryLogIndex() {
        return this.repositoryLogIndex;
    }

    public RepositoryLogFileIndex getRepositoryLogFileIndex() {
        return this.repositoryLogFileIndex;
    }

    public WorkItemHistoryIndexAggregation<SpecItem> getSpecItemHistoryIndex() {
        return this.specItemHistoryIndex;
    }

    public ProjectStorageSystem getProjectStorageSystem() {
        return this.projectStorageSystem;
    }

    public GlobalStorageSystem getGlobalStorageSystem() {
        return this.globalStorageSystem;
    }

    public CommitDescriptor getSourceBranchHead() {
        return this.sourceBranchHead;
    }

    public CommitDescriptor getMergeBase() {
        return this.mergeBaseInfo.getMergeBase();
    }

    public MergeBaseInfo getMergeBaseInfo() {
        return this.mergeBaseInfo;
    }

    public Set<CommitDescriptor> getAncestorsOfSource() {
        return this.ancestorsOfSource;
    }

    public HistoryAccessOption getHistoryAccessOptionAtSourceHead() {
        return this.historyAccessOptionAtSourceHead;
    }

    public IParallelTaskExecutor getParallelTaskExecutor() {
        return this.parallelTaskExecutor;
    }

    public boolean specItemReferencesPresentInCodeBase() throws StorageException {
        return this.specItemCodeReferenceIndexAtMergeBase.getSpecItemCodeReferences("##non-empty##") != null || this.specItemCodeReferenceIndexAtSourceHead.getSpecItemCodeReferences("##non-empty##") != null;
    }
}

