/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.element_details;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.resource.element_details.EIncludePathSearchType;
import com.teamscale.index.resource.element_details.IncludeSearchPathEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.lib.commons.js_export.ExportAsType;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public class IncludePathDetail
extends TokenElementDetailBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="includeSearchPaths")
    private @ExportAsType(value="Array<{searchPathType: EIncludePathSearchType, searchPath: string}>") List<IncludeSearchPathEntry> includeSearchPaths = new ArrayList<IncludeSearchPathEntry>();

    public void addToPath(EIncludePathSearchType searchType, String pathElement) {
        this.includeSearchPaths.add(new IncludeSearchPathEntry(searchType, pathElement));
    }

    public void addToPath(IncludePathDetail includePathDetail) {
        this.includeSearchPaths.addAll(includePathDetail.includeSearchPaths);
    }

    public void addToPath(Collection<String> pathElements) {
        pathElements.forEach(path -> this.includeSearchPaths.add(new IncludeSearchPathEntry(EIncludePathSearchType.I_GCC, (String)path)));
    }

    public void removeSearchPathsWithMatching(Pattern searchPattern) {
        this.includeSearchPaths.removeIf(searchPath -> searchPattern.matcher(searchPath.searchPath()).matches());
    }

    public List<String> getResolvedIncludeSearchPaths() {
        return this.includeSearchPaths.stream().map(IncludeSearchPathEntry::resolvedSearchPath).toList();
    }

    public List<String> getIncludePathOptions() {
        return this.includeSearchPaths.stream().map(Objects::toString).toList();
    }

    public List<IncludeSearchPathEntry> getIncludeSearchPathEntries() {
        return this.includeSearchPaths;
    }
}

