/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.google.common.collect.Lists;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import com.teamscale.index.s3.IS3Client;
import com.teamscale.index.s3.S3Exception;
import com.teamscale.index.s3.S3MultiPartOutputStream;
import com.teamscale.index.s3.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Object;

class S3Client
implements IS3Client {
    private static final int MAX_KEYS_PER_BATCH = 1000;
    private static final int THREAD_POOL_SIZE = TeamscaleSystemProperties.S3_THREAD_POOL_SIZE.getValue().orElse(40);
    private static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    private final software.amazon.awssdk.services.s3.S3Client s3Client;
    private final @Nullable AwsCredentialsProvider credentialsProvider;

    public S3Client(software.amazon.awssdk.services.s3.S3Client s3Client, @Nullable AwsCredentialsProvider credentialsProvider) {
        this.s3Client = s3Client;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public InputStream getObjectContent(String bucket, String fullPath) throws S3Exception {
        try {
            return (InputStream)this.s3Client.getObject(b -> b.bucket(bucket).key(fullPath), ResponseTransformer.toInputStream());
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void writeObjectToFile(String bucket, String key, File file) throws S3Exception {
        try {
            this.s3Client.getObject(b -> b.bucket(bucket).key(key), file.toPath());
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public Instant getLastModified(String bucket, String fullPath) throws S3Exception {
        try {
            return this.s3Client.headObject(b -> b.bucket(bucket).key(fullPath)).lastModified();
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public long getContentLength(String bucket, String fullPath) throws S3Exception {
        try {
            return this.s3Client.headObject(b -> b.bucket(bucket).key(fullPath)).contentLength();
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void putObject(String bucket, String targetPath, InputStream dataStream, String contentType, long contentLength) throws S3Exception {
        try {
            byte[] data = dataStream.readAllBytes();
            this.s3Client.putObject(b -> b.bucket(bucket).key(targetPath).contentType(contentType).contentLength(Long.valueOf(contentLength)), RequestBody.fromBytes((byte[])data));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putObject(String bucket, String targetPath, String content) throws S3Exception {
        try {
            this.s3Client.putObject(b -> b.bucket(bucket).key(targetPath), RequestBody.fromString((String)content));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void deleteObject(String bucket, String path) throws S3Exception {
        try {
            this.s3Client.deleteObject(b -> b.bucket(bucket).key(path));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public List<S3ObjectSummary> getAllObjectSummaries(String bucket, String prefix) throws S3Exception {
        try {
            ListObjectsV2Request.Builder request = ListObjectsV2Request.builder().bucket(bucket).prefix(prefix.trim()).maxKeys(Integer.valueOf(1000));
            ListObjectsV2Response response = this.s3Client.listObjectsV2((ListObjectsV2Request)request.build());
            ArrayList summaries = new ArrayList(response.contents());
            while (response.isTruncated().booleanValue()) {
                response = this.s3Client.listObjectsV2((ListObjectsV2Request)request.continuationToken(response.nextContinuationToken()).build());
                summaries.addAll(response.contents());
            }
            return CollectionUtils.map(summaries, S3ObjectSummary::createFromAwsObject);
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public List<S3ObjectSummary> getAllObjectSummariesOptimizedByKnownPaths(String bucket, String prefix, ItemQueryResultData knownPaths) throws S3Exception {
        List keyChunks = Lists.partition(knownPaths.results.stream().map(ArtifactStoreItemData::getFullPath).sorted().toList(), (int)Math.max(knownPaths.results.size() / THREAD_POOL_SIZE, 1000));
        List<Pair<String, String>> chunkStartEndKeyPairs = S3Client.createStartAndEndKeyPairsForEachChunk(keyChunks);
        ArrayList<Future<List<S3ObjectSummary>>> futures = new ArrayList<Future<List<S3ObjectSummary>>>();
        software.amazon.awssdk.services.s3.S3Client s3Client = this.s3Client;
        for (Pair<String, String> chunkStartAndEndPair : chunkStartEndKeyPairs) {
            futures.add(THREAD_POOL.submit(() -> S3Client.getS3ObjectSummariesForKeyChunk(s3Client, bucket, prefix, chunkStartAndEndPair)));
        }
        return S3Client.waitForAndCollectObjectSummaries(futures);
    }

    private static @NonNull List<S3ObjectSummary> getS3ObjectSummariesForKeyChunk(software.amazon.awssdk.services.s3.S3Client s3Client, String bucket, String prefix, Pair<String, String> startEndKeyPair) throws S3Exception {
        try {
            ListObjectsV2Request.Builder request = ListObjectsV2Request.builder().bucket(bucket).prefix(prefix.trim()).startAfter((String)startEndKeyPair.getFirst()).maxKeys(Integer.valueOf(1000));
            ListObjectsV2Response response = s3Client.listObjectsV2((ListObjectsV2Request)request.build());
            ArrayList summaries = new ArrayList(response.contents());
            while (response.isTruncated().booleanValue() && (startEndKeyPair.getSecond() == null || ((S3Object)summaries.getLast()).key().compareTo((String)startEndKeyPair.getSecond()) < 0)) {
                response = s3Client.listObjectsV2((ListObjectsV2Request)request.continuationToken(response.nextContinuationToken()).build());
                summaries.addAll(response.contents());
            }
            return CollectionUtils.map(summaries, S3ObjectSummary::createFromAwsObject);
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    private static @NonNull List<Pair<String, String>> createStartAndEndKeyPairsForEachChunk(List<List<String>> keyChunks) {
        if (keyChunks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> chunkStartEndKeyPairs = new ArrayList<Pair<String, String>>();
        chunkStartEndKeyPairs.add(new Pair(null, (Object)keyChunks.getFirst().getFirst()));
        for (int i = 0; i < keyChunks.size() - 1; ++i) {
            chunkStartEndKeyPairs.add((Pair<String, String>)new Pair((Object)keyChunks.get(i).getFirst(), (Object)keyChunks.get(i + 1).getFirst()));
        }
        chunkStartEndKeyPairs.add(new Pair((Object)keyChunks.getLast().getFirst(), null));
        return chunkStartEndKeyPairs;
    }

    private static @NonNull List<S3ObjectSummary> waitForAndCollectObjectSummaries(List<Future<List<S3ObjectSummary>>> futures) throws S3Exception {
        ArrayList<S3ObjectSummary> allObjectSummaries = new ArrayList<S3ObjectSummary>();
        for (Future<List<S3ObjectSummary>> future : futures) {
            try {
                List<S3ObjectSummary> result = future.get();
                allObjectSummaries.addAll(result);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new S3Exception("Failed to list objects", e);
            }
        }
        return allObjectSummaries.stream().sorted(Comparator.comparing(S3ObjectSummary::key)).distinct().toList();
    }

    @Override
    public void validateCredentials() throws S3Exception {
        try {
            if (this.credentialsProvider != null) {
                this.credentialsProvider.resolveCredentials();
            }
        }
        catch (IllegalStateException e) {
            throw new S3Exception(String.format("Failed to validate S3 credentials: %s", e.getMessage()), e);
        }
    }

    @Override
    public List<S3ObjectSummary> listObjects(String bucket, String keyPrefix) throws S3Exception {
        try {
            return CollectionUtils.map((Collection)this.s3Client.listObjectsV2(b -> b.bucket(bucket).prefix(keyPrefix)).contents(), S3ObjectSummary::createFromAwsObject);
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void validateRead(String bucket, String keyPrefix) throws S3Exception {
        try {
            this.s3Client.listObjects(b -> b.bucket(bucket).prefix(keyPrefix).maxKeys(Integer.valueOf(1)));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public OutputStream initiateMultipartUpload(String bucket, String key) throws S3Exception {
        try {
            return S3MultiPartOutputStream.init(this.s3Client, bucket, key);
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void deleteObjects(String bucket, Stream<String> keys) throws S3Exception {
        try {
            List<ObjectIdentifier> objectsToDelete = keys.map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).toList();
            this.s3Client.deleteObjects(b -> b.bucket(bucket).delete(d -> d.objects((Collection)objectsToDelete)));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void createBucket(String bucket) throws S3Exception {
        try {
            this.s3Client.headBucket(b -> b.bucket(bucket));
        }
        catch (SdkException e) {
            if (e instanceof NoSuchBucketException) {
                this.createBucketUnchecked(bucket);
            }
            throw new S3Exception(e, bucket);
        }
    }

    private void createBucketUnchecked(String bucket) throws S3Exception {
        try {
            this.s3Client.createBucket(b -> b.bucket(bucket));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }
}

