/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.service_log;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="service-load", options={EStorageOption.BACKUP}, valueClasses={ServiceLoadEntry.class})
public class ServiceLoadIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "service-load";

    public ServiceLoadIndex(IStore store) {
        super(store);
    }

    public List<ServiceLoadEntry> getLoadEntriesSince(long timestamp) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(ServiceLoadIndex.makeHourKey(timestamp), null, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceCalls(long currentTimeMillis, int serviceCallCount) throws StorageException {
        byte[] key = ServiceLoadIndex.makeHourKey(currentTimeMillis);
        Lock lock = this.store.obtainLock("update");
        try {
            lock.lock();
            byte[] value = this.store.get(key);
            ServiceLoadEntry entry = value == null ? new ServiceLoadEntry(currentTimeMillis) : (ServiceLoadEntry)StorageUtils.deserialize((byte[])value);
            entry.addServiceCallsForMinute(serviceCallCount);
            this.store.put(key, StorageUtils.serialize((Serializable)entry));
        }
        finally {
            lock.unlock();
        }
    }

    private static byte[] makeHourKey(long timestamp) {
        long hours = timestamp / 3600000L;
        return ByteArrayUtils.longToByteArray((long)hours);
    }

    @IndexValueClass(containedInBackup=true)
    public static class ServiceLoadEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long timestamp;
        private int sumServiceCalls = 0;
        private int numMinuteIntervals;
        private int maxServiceCalls = 0;

        public ServiceLoadEntry(long timestamp) {
            this.timestamp = timestamp / 3600000L * 3600000L;
        }

        private void addServiceCallsForMinute(int serviceCalls) {
            this.sumServiceCalls += serviceCalls;
            ++this.numMinuteIntervals;
            this.maxServiceCalls = Math.max(this.maxServiceCalls, serviceCalls);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getSumServiceCalls() {
            return this.sumServiceCalls;
        }

        public int getNumMinuteIntervals() {
            return this.numMinuteIntervals;
        }

        public int getMaxServiceCalls() {
            return this.maxServiceCalls;
        }
    }
}

