/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import java.util.List;
import java.util.Objects;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="simulink-coverable-blocks", options={EStorageOption.BRANCHED}, valueClasses={Integer.class})
public class SimulinkCoverableBlockCountIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "simulink-coverable-blocks";

    public SimulinkCoverableBlockCountIndex(IStore store) {
        super(store);
    }

    public void deleteValuesForModels(List<String> uniformPaths) throws StorageException {
        for (String uniformPath : uniformPaths) {
            this.store.removeByPrefix(StringUtils.stringToBytes((String)(uniformPath + "##")));
        }
    }

    public void updateVaues(PairList<String, Integer> rawKeyAndCount) throws StorageException {
        this.store.putWithStrings(rawKeyAndCount.mapSecond(ByteArrayUtils::intToByteArray));
    }

    static String makeRawKey(String uniformPath, String blockId) {
        return uniformPath + "##" + blockId;
    }

    static String makeRootKey(String uniformPath) {
        return SimulinkCoverableBlockCountIndex.makeRawKey(uniformPath, "");
    }

    public int getRootCount(String uniformPath) throws StorageException {
        byte[] value = this.store.getWithString(SimulinkCoverableBlockCountIndex.makeRootKey(uniformPath));
        if (value == null) {
            return 0;
        }
        return ByteArrayUtils.byteArrayToInt((byte[])value);
    }

    public int getCountSumForRawKeys(List<String> rawKeys) throws StorageException {
        List values = this.store.getWithStrings(rawKeys);
        return values.stream().filter(Objects::nonNull).mapToInt(ByteArrayUtils::byteArrayToInt).sum();
    }
}

