/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import com.teamscale.index.testgap.abap.structure.EBwDtpFields;
import com.teamscale.index.testgap.abap.structure.EBwQueryFields;
import com.teamscale.index.testgap.abap.structure.EBwTransformationFields;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class BwPathTransformation
implements Function<String, String> {
    private static final Pattern TRANS_NAME_PATTERN = Pattern.compile("^(.*)$");
    private static final Pattern DTP_NAME_PATTERN = Pattern.compile("^DTP_(.*)$");
    private static final Pattern QUERY_NAME_PATTERN = Pattern.compile("^GP(.*)$");
    private static final String GENERATED_SOURCES_DIR_PREFIX = "$TMP/PROG/";
    private final Map<String, String> transformations = new HashMap<String, String>();

    public BwPathTransformation(List<Map<EBwTransformationFields, String>> transformationData, List<Map<EBwDtpFields, String>> dtpData, List<Map<EBwQueryFields, String>> queryData) {
        this.addTransformations(transformationData, TRANS_NAME_PATTERN, EBwTransformationFields.TRANID, EBwTransformationFields.TRANPROG, BwPathTransformation::createBwTransformationPath);
        this.addTransformations(dtpData, DTP_NAME_PATTERN, EBwDtpFields.DTP, EBwDtpFields.DTP, BwPathTransformation::createBwDtpPath);
        this.addTransformations(queryData, QUERY_NAME_PATTERN, EBwQueryFields.COMPUID, EBwQueryFields.RNAME, BwPathTransformation::createBwQueryPath);
    }

    private static String createBwTransformationPath(Map<EBwTransformationFields, String> record, String generatedName) {
        return BwPathTransformation.createBwDtpOrTransformationPath(record, generatedName, EBwTransformationFields.TARGETTYPE, EBwTransformationFields.TARGETNAME, EBwTransformationFields.SOURCETYPE, EBwTransformationFields.SOURCENAME, "Transformation");
    }

    private static String createBwDtpPath(Map<EBwDtpFields, String> record, String generatedName) {
        return BwPathTransformation.createBwDtpOrTransformationPath(record, generatedName, EBwDtpFields.TGTTP, EBwDtpFields.TGT, EBwDtpFields.SRCTP, EBwDtpFields.SRC, "DTP");
    }

    private static <E extends Enum<E>> String createBwDtpOrTransformationPath(Map<E, String> record, String generatedName, E targetTypeField, E targetNameField, E sourceTypeField, E sourceNameField, String programType) {
        StringBuilder sb = new StringBuilder("BW Objects");
        sb.append("/Transformations and DTPs by Target/");
        BwPathTransformation.appendField(record, sb, targetTypeField);
        sb.append("/");
        BwPathTransformation.appendField(record, sb, targetNameField);
        sb.append("/Source ");
        BwPathTransformation.appendField(record, sb, sourceTypeField);
        sb.append(" ");
        BwPathTransformation.appendField(record, sb, sourceNameField);
        sb.append(" (");
        sb.append(programType);
        sb.append(" ");
        sb.append(generatedName);
        sb.append(").abap");
        return sb.toString();
    }

    private static String createBwQueryPath(Map<EBwQueryFields, String> record, String generatedName) {
        StringBuilder sb = new StringBuilder("BW Objects");
        sb.append("/Queries by InfoCube/");
        BwPathTransformation.appendField(record, sb, EBwQueryFields.INFOCUBE);
        sb.append("/Component ");
        BwPathTransformation.appendField(record, sb, EBwQueryFields.COMPID);
        sb.append(" (Query ");
        sb.append(generatedName);
        sb.append(").abap");
        return sb.toString();
    }

    private static <E extends Enum<E>> void appendField(Map<E, String> record, StringBuilder sb, E field) {
        sb.append(record.get(field).replace('/', '!').replaceAll("\\s\\s+", " "));
    }

    @Override
    public String apply(String uniformPath) {
        String transformedPath = this.transformations.get(uniformPath);
        if (transformedPath == null) {
            return uniformPath;
        }
        return transformedPath;
    }

    private <E extends Enum<E>> void addTransformations(List<Map<E, String>> records, Pattern sourcePattern, E bwObjectNameField, E generatedProgramNameField, BiFunction<Map<E, String>, String, String> recordToPath) {
        for (Map<E, String> record : records) {
            String recordName = record.get(generatedProgramNameField);
            Matcher matcher = sourcePattern.matcher(recordName);
            CCSMAssert.isTrue((boolean)matcher.matches(), (String)("The source pattern " + String.valueOf(sourcePattern) + " does not match the generated program name " + recordName + " parsed from the XML."));
            String programName = "GP" + matcher.group(1);
            String objectName = AbapUtils.formatAbapIdentifier((String)record.get(bwObjectNameField));
            this.transformations.put(GENERATED_SOURCES_DIR_PREFIX + programName + ".abap", recordToPath.apply(record, objectName));
        }
    }
}

