/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.TestOnly;

public class UnassessedTestGapData {
    public static final int UNTESTED_TIMESTAMP = -1;
    private final List<UnassessedMethodData> methods = new ArrayList<UnassessedMethodData>();

    public UnassessedTestGapData(List<UnassessedMethodData> unassendMethods) {
        this.methods.addAll(unassendMethods);
    }

    public UnassessedTestGapData() {
    }

    public void addMethod(UnassessedMethodData methodData) {
        this.methods.add(methodData);
    }

    public List<UnassessedMethodData> getMethods() {
        return this.methods;
    }

    public String toString() {
        return "UnassessedTestGapData [" + String.valueOf(this.methods) + "]";
    }

    public static class UnassessedMethodData {
        private final MethodLocation location;
        private final long lastChangeTimestamp;
        private final long lastTestTimestamp;
        private final long creationTimestamp;
        private final boolean isExecutedByCrossAnnotation;
        private final String methodName;
        private final TeamscaleIssueId lastChangedInIssueId;

        public UnassessedMethodData(MethodLocation location, long creationTimestamp, long lastChangeTimestamp, long lastTestTimestamp, boolean isExecutedByCrossAnnotation, String methodName, TeamscaleIssueId lastChangedInIssueId) {
            this.location = location;
            this.lastChangeTimestamp = lastChangeTimestamp;
            this.lastTestTimestamp = lastTestTimestamp;
            this.creationTimestamp = creationTimestamp;
            this.isExecutedByCrossAnnotation = isExecutedByCrossAnnotation;
            this.methodName = methodName;
            this.lastChangedInIssueId = lastChangedInIssueId;
        }

        public UnassessedMethodData(MethodLocation location, long creationTimestamp, long lastChangeTimestamp, long lastTestTimestamp, boolean isExecutedByCrossAnnotation, String methodName) {
            this(location, creationTimestamp, lastChangeTimestamp, lastTestTimestamp, isExecutedByCrossAnnotation, methodName, null);
        }

        @TestOnly
        public UnassessedMethodData(String methodName, MethodLocation location) {
            this(location, -1L, -1L, -1L, false, methodName);
        }

        public MethodLocation getLocation() {
            return this.location;
        }

        public long getLastChangeTimestamp() {
            return this.lastChangeTimestamp;
        }

        public long getLastTestTimestamp() {
            return this.lastTestTimestamp;
        }

        public boolean isExecutedByCrossAnnotation() {
            return this.isExecutedByCrossAnnotation;
        }

        public long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public TeamscaleIssueId getLastChangedInIssueId() {
            return this.lastChangedInIssueId;
        }

        public UnassessedMethodData withUniformPath(UniformPath newUniformPath) {
            return new UnassessedMethodData(new MethodLocation(newUniformPath, this.location.getRegion()), this.creationTimestamp, this.lastChangeTimestamp, this.lastTestTimestamp, this.isExecutedByCrossAnnotation, this.methodName, this.lastChangedInIssueId);
        }

        public UnassessedMethodData withLastChangeTimestamp(long lastChangeTimestamp) {
            return new UnassessedMethodData(this.location, this.creationTimestamp, lastChangeTimestamp, this.lastTestTimestamp, this.isExecutedByCrossAnnotation, this.methodName, this.lastChangedInIssueId);
        }

        public UnassessedMethodData withLastChangeInIssueId(long lastChangeTimestamp, TeamscaleIssueId lastChangedInIssueId) {
            return new UnassessedMethodData(this.location, this.creationTimestamp, lastChangeTimestamp, this.lastTestTimestamp, this.isExecutedByCrossAnnotation, this.methodName, lastChangedInIssueId);
        }

        public String toString() {
            return "UnassessedMethodData [location=" + String.valueOf(this.location) + ", methodName=" + this.methodName + ", lastChangeTimestamp=" + this.lastChangeTimestamp + ", lastTestTimestamp=" + this.lastTestTimestamp + ", creationTimestamp=" + this.creationTimestamp + ", isExecutedByCrossAnnotation=" + this.isExecutedByCrossAnnotation + ", lastChangedInIssueId=" + String.valueOf(this.lastChangedInIssueId) + "]";
        }
    }
}

