/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
public class IssueTgaParameters {
    public static final String AUTO_SELECT_BRANCH_PARAMETER_NAME = "auto-select-branch";
    public static final String BRANCH_PARAMETER_NAME = "branch-name";
    private static final String INCLUDE_CHILD_ISSUES_PARAMETER = "include-child-issues";
    private static final String END_TIMESTAMP_ISSUE_BRANCH_SELECTION_DOC = "If this is given, all issues are shown on this branch. Otherwise, the branch is auto-determined for each issue separately.";
    @JsonProperty(value="autoSelectBranch")
    @QueryParam(value="auto-select-branch")
    @Parameter(description="Will auto-select the issue branch if set to true. Otherwise, if given, the branchName will be used. As fallback the default branch will be used.")
    @DefaultValue(value="true")
    private boolean autoSelectBranch;
    @JsonProperty(value="branchName")
    @QueryParam(value="branch-name")
    @Parameter(description="If this is given, all issues are shown on this branch. Otherwise, the branch is auto-determined for each issue separately.")
    private @Nullable String branchName;
    @JsonProperty(value="includeChildIssues")
    @QueryParam(value="include-child-issues")
    @Parameter(description="Will include changes introduced by child issues.")
    private boolean includeChildIssues;

    @JsonCreator
    public IssueTgaParameters() {
    }

    public IssueTgaParameters(boolean autoSelectBranch, @Nullable String branchName, boolean includeChildIssues) {
        this.autoSelectBranch = autoSelectBranch;
        this.branchName = branchName;
        this.includeChildIssues = includeChildIssues;
    }

    public boolean isBranchExplicitlySpecified() {
        return !this.autoSelectBranch && !StringUtils.isEmpty((String)this.branchName);
    }

    public boolean shouldIncludeChildIssues() {
        return this.includeChildIssues;
    }

    public @Nullable String getBranchName() {
        return this.branchName;
    }

    public void patchBranchName(TimeIntervalBasedServiceQueryOptions timeInterval) {
        if (timeInterval.getEndCommit() != null && !this.isBranchExplicitlySpecified()) {
            this.branchName = timeInterval.getEndCommit().getBranchName();
        }
    }
}

