/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.FindingDeltaUtils;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.Pair;

public enum EFindingIdentificationCriterion {
    MESSAGE('m'){

        @Override
        public Optional<String> calculateCriterion(IndexFinding finding, TrackedElement element) {
            return Optional.of(FindingDeltaUtils.getNormalizedFindingMessage(finding));
        }
    }
    ,
    CONTENT('c'){

        @Override
        public Optional<String> calculateCriterion(IndexFinding finding, TrackedElement element) {
            if (finding.getLocation() instanceof QualifiedNameLocation) {
                return Optional.of(((QualifiedNameLocation)finding.getLocation()).getQualifiedName());
            }
            List<TrackedUnit> units = element.getUnits();
            if (!(finding.getLocation() instanceof TextRegionLocation)) {
                return Optional.of(EFindingIdentificationCriterion.joinUnits(units));
            }
            Optional<Pair<Integer, Integer>> startAndEndIndex = 2.getStartAndEndIndex(finding, element);
            if (startAndEndIndex.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(EFindingIdentificationCriterion.joinUnits(units, (Integer)startAndEndIndex.get().getFirst(), (Integer)startAndEndIndex.get().getSecond() + 1));
        }
    }
    ,
    NARROW_CONTEXT('n'){

        @Override
        public Optional<String> calculateCriterion(IndexFinding finding, TrackedElement element) {
            return EFindingIdentificationCriterion.calculateContextCriterion(finding, element, 5);
        }
    }
    ,
    WIDE_CONTEXT('w'){

        @Override
        public Optional<String> calculateCriterion(IndexFinding finding, TrackedElement element) {
            return EFindingIdentificationCriterion.calculateContextCriterion(finding, element, 50);
        }
    }
    ,
    FILE_NAME('f'){

        @Override
        public Optional<String> calculateCriterion(IndexFinding finding, TrackedElement element) {
            return Optional.of(element.getUniformPath());
        }
    };

    public static final int SIZE;
    private final byte[] keyPrefix;
    private static final Map<Byte, EFindingIdentificationCriterion> CRITERION_BY_PREFIX;

    private EFindingIdentificationCriterion(char keyPrefix) {
        this.keyPrefix = new byte[]{(byte)keyPrefix};
    }

    public abstract Optional<String> calculateCriterion(IndexFinding var1, TrackedElement var2);

    private static Optional<String> calculateContextCriterion(IndexFinding finding, TrackedElement element, int tokenCount) {
        if (!(finding.getLocation() instanceof TextRegionLocation)) {
            return Optional.empty();
        }
        Optional<Pair<Integer, Integer>> startAndEndIndex = EFindingIdentificationCriterion.getStartAndEndIndex(finding, element);
        if (startAndEndIndex.isEmpty()) {
            return Optional.empty();
        }
        List<TrackedUnit> units = element.getUnits();
        return Optional.of(EFindingIdentificationCriterion.joinUnits(units, (Integer)startAndEndIndex.get().getFirst() - tokenCount, (Integer)startAndEndIndex.get().getFirst()) + "--" + EFindingIdentificationCriterion.joinUnits(units, (Integer)startAndEndIndex.get().getSecond() + 1, (Integer)startAndEndIndex.get().getSecond() + 1 + tokenCount));
    }

    static Optional<Pair<Integer, Integer>> getStartAndEndIndex(IndexFinding finding, TrackedElement element) {
        List<TrackedUnit> units = element.getUnits();
        TextRegionLocation location = (TextRegionLocation)finding.getLocation();
        int startIndex = element.getUnitIndexForOffset(location.getRawStartOffset());
        int endIndex = element.getUnitIndexForOffset(location.getRawEndOffset());
        if (endIndex < startIndex || startIndex >= units.size()) {
            return Optional.empty();
        }
        if (endIndex == units.size() || location.getRawEndOffset() < units.get(endIndex).getStartOffset()) {
            --endIndex;
        }
        return Optional.of(new Pair((Object)startIndex, (Object)endIndex));
    }

    private static String joinUnits(List<TrackedUnit> units, int inclusiveStart, int exclusiveEnd) {
        if ((inclusiveStart = Math.max(0, inclusiveStart)) >= (exclusiveEnd = Math.min(exclusiveEnd, units.size()))) {
            return "";
        }
        return EFindingIdentificationCriterion.joinUnits(units.subList(inclusiveStart, exclusiveEnd));
    }

    private static String joinUnits(List<TrackedUnit> units) {
        return units.stream().map(TrackedUnit::getContent).collect(Collectors.joining());
    }

    public byte[] getKeyPrefix() {
        return this.keyPrefix;
    }

    public static EFindingIdentificationCriterion extractCriterion(byte[] key) {
        return CRITERION_BY_PREFIX.get(key[0]);
    }

    static {
        SIZE = EFindingIdentificationCriterion.values().length;
        CRITERION_BY_PREFIX = new HashMap<Byte, EFindingIdentificationCriterion>(20);
        for (EFindingIdentificationCriterion criterion : EFindingIdentificationCriterion.values()) {
            CRITERION_BY_PREFIX.put(criterion.keyPrefix[0], criterion);
        }
    }
}

