/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.ClusteringMatchingStrategyBase;
import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import com.teamscale.index.tracking.algorithm.TrackedUnitUtils;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;

public class SameFileExactMatchingStrategy
extends ClusteringMatchingStrategyBase {
    @Override
    protected void performMatching(List<TrackedFindingWithContext> oldFindings, List<TrackedFindingWithContext> newFindings, PairList<TrackedFindingWithContext, TrackedFindingWithContext> trackingResult) {
        if (oldFindings.size() > 1) {
            TrackedFinding oldId = oldFindings.get(0).getFinding();
            oldFindings.removeIf(finding -> finding.getFinding().equals((Object)oldId));
        }
        if (oldFindings.size() == 1 && newFindings.size() == 1) {
            trackingResult.add((Object)oldFindings.get(0), (Object)newFindings.get(0));
        }
    }

    @Override
    protected ListMap<String, TrackedFindingWithContext> clusterByRepresentation(Set<TrackedFindingWithContext> findings) {
        ListMap clustered = new ListMap();
        for (TrackedFindingWithContext finding : findings) {
            StringBuilder representation = new StringBuilder(finding.getNormalizedMessage());
            representation.append(finding.getUniformPath());
            TrackedUnitUtils.appendUnits(finding.getContent(), representation, false);
            clustered.add((Object)representation.toString(), (Object)finding);
        }
        return clustered;
    }
}

