/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import com.teamscale.index.tracking.algorithm.TrackedUnitUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

class TextRegionLocationContext {
    private static final int CONTEXT_LENGTH = 2;
    private final List<TrackedUnit> preContext = new ArrayList<TrackedUnit>();
    private final List<TrackedUnit> content = new ArrayList<TrackedUnit>();
    private final List<TrackedUnit> postContext = new ArrayList<TrackedUnit>();
    private final TrackedElement element;
    private final Map<Integer, TrackedElement> peerElementsByBranchIndex = new HashMap<Integer, TrackedElement>();
    private final int contentStartUnitIndex;

    public TextRegionLocationContext(TextRegionLocation location, TrackedElement element) {
        this.contentStartUnitIndex = this.fillContext(location, element);
        this.element = element;
    }

    public TextRegionLocationContext(TrackedElement element) {
        this.contentStartUnitIndex = -1;
        this.element = element;
    }

    private int fillContext(TextRegionLocation location, TrackedElement element) {
        int i;
        int endIndex;
        CCSMAssert.isFalse((boolean)element.getUnits().isEmpty(), (String)"Can not create finding context for empty element.");
        int startOffset = location.getRawStartOffset();
        int endOffset = location.getRawEndOffset();
        int startIndex = TextRegionLocationContext.determineStartIndex(startOffset, endOffset, element);
        for (endIndex = startIndex + 1; endIndex < element.getUnits().size() && element.getUnits().get(endIndex).getStartOffset() < endOffset; ++endIndex) {
        }
        for (i = Math.max(0, startIndex - 2); i < startIndex; ++i) {
            this.preContext.add(element.getUnits().get(i));
        }
        for (i = startIndex; i < endIndex; ++i) {
            this.content.add(element.getUnits().get(i));
        }
        for (i = endIndex; i < endIndex + 2 && i < element.getUnits().size(); ++i) {
            this.postContext.add(element.getUnits().get(i));
        }
        return startIndex;
    }

    private static int determineStartIndex(int startOffset, int endOffset, TrackedElement element) {
        int startIndex = Collections.binarySearch(element.getUnits(), new TrackedUnit("", startOffset, endOffset), Comparator.comparingInt(TrackedUnit::getStartOffset));
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex > 0 && element.getUnits().get(startIndex - 1).getEndOffset() > startOffset) {
            --startIndex;
        }
        if (startIndex > 0 && startIndex < element.getUnits().size() && element.getUnits().get(startIndex).getStartOffset() > endOffset) {
            --startIndex;
        }
        if (startIndex >= element.getUnits().size()) {
            startIndex = element.getUnits().size() - 1;
        }
        return startIndex;
    }

    public int getContentStartUnitIndex() {
        return this.contentStartUnitIndex;
    }

    public int getContentLength() {
        return this.content.size();
    }

    List<TrackedUnit> getPreContext() {
        return this.preContext;
    }

    List<TrackedUnit> getContent() {
        return this.content;
    }

    List<TrackedUnit> getPostContext() {
        return this.postContext;
    }

    void setPeerElementForBranch(TrackedElement peerElement, int branchIndex) {
        this.peerElementsByBranchIndex.put(branchIndex, peerElement);
    }

    TrackedElement getPeerElementForBranch(int branchIndex) {
        return this.peerElementsByBranchIndex.get(branchIndex);
    }

    TrackedElement getElement() {
        return this.element;
    }

    public String getExactRepresentation(boolean includeOffsets) {
        StringBuilder builder = new StringBuilder();
        TrackedUnitUtils.appendUnits(this.preContext, builder, includeOffsets);
        builder.append(StringUtils.LINE_SEPARATOR).append("---");
        TrackedUnitUtils.appendUnits(this.content, builder, includeOffsets);
        builder.append(StringUtils.LINE_SEPARATOR).append("---");
        TrackedUnitUtils.appendUnits(this.postContext, builder, includeOffsets);
        return builder.toString();
    }

    public String toString() {
        return this.getExactRepresentation(true);
    }
}

