/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.teamscale.core.runtime.api.ProcessIdManager;
import java.time.Duration;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;

public class ClockDriftDetector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CHANNEL = "clock-drift";
    private static final long THRESHOLD_MILLIS = Duration.ofSeconds(2L).toMillis();

    public static void setup(final IMessageBroker messageBroker) {
        messageBroker.registerListener(CHANNEL, ClockDriftDetector::handleClockDriftMessage);
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                messageBroker.sendMessage(ClockDriftDetector.CHANNEL, ProcessIdManager.getProcessId() + ":" + System.currentTimeMillis());
            }
        }, 0L, Duration.ofMinutes(10L).toMillis());
    }

    private static void handleClockDriftMessage(String message) {
        String remoteProcessId;
        String[] parts = message.split(":", 2);
        String myProcessId = ProcessIdManager.getProcessId();
        if (Objects.equals(myProcessId, remoteProcessId = parts[0])) {
            return;
        }
        try {
            long remoteTime = Long.parseLong(parts[1]);
            if (Math.abs(System.currentTimeMillis() - remoteTime) > THRESHOLD_MILLIS) {
                LOGGER.error("Detected clock drift in the system between me (" + myProcessId + ") and " + remoteProcessId + " of " + Math.abs(System.currentTimeMillis() - remoteTime) + "ms");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Malformed clock drift message received: " + message);
        }
    }
}

