/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.anthropic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.rest.client.authentication.ICustomAuthenticationInterceptor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public class AnthropicClient
implements ILlmCompleter {
    private static final String BASE_URL = "https://api.anthropic.com/v1/";
    private static final String ANTHROPIC_AUTHENTICATION_HEADER_NAME = "x-api-key";
    private static final String ANTHROPIC_VERSION_HEADER_NAME = "anthropic-version";
    private static final String ANTHROPIC_API_VERSION = "2023-06-01";
    private static final Logger LOGGER = LogManager.getLogger();
    private final String model;
    private final boolean thinking;
    private final IAnthropicService service;
    private final double temperature;
    private final @Nullable BiConsumer<String, Long> usageReporter;

    public AnthropicClient(String model, String apiKey, boolean thinking, double temperature, @Nullable BiConsumer<String, Long> usageReporter) {
        this.model = model;
        this.service = AnthropicClient.createService(apiKey);
        this.thinking = thinking;
        this.temperature = temperature;
        this.usageReporter = usageReporter;
    }

    private static IAnthropicService createService(final String apiKey) {
        ICustomAuthenticationInterceptor interceptor = new ICustomAuthenticationInterceptor(){

            public @NonNull Response intercept(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull Interceptor.Chain chain) throws IOException {
                return chain.proceed(chain.request().newBuilder().header(AnthropicClient.ANTHROPIC_VERSION_HEADER_NAME, AnthropicClient.ANTHROPIC_API_VERSION).header(AnthropicClient.ANTHROPIC_AUTHENTICATION_HEADER_NAME, apiKey).build());
            }
        };
        return (IAnthropicService)Retrofit.builder((String)BASE_URL).withNoAuthentication().withCustomAuthenticationInterceptor(interceptor).withInteractionLogger(LOGGER).create(IAnthropicService.class);
    }

    public Optional<String> getModelDisplayName() throws ServiceCallException {
        return Retrofit.executeServiceCall(this.service.getModelDescription(this.model)).map(AnthropicModelDescription::displayName);
    }

    @Override
    public String complete(LlmPrompt prompt) throws ServiceCallException {
        int maxTokens = 8192;
        if (this.model.contains("claude-3-7-sonnet")) {
            maxTokens = 64000;
        }
        AnthropicThinking thinkingConfig = null;
        if (this.thinking) {
            thinkingConfig = new AnthropicThinking("enabled", maxTokens / 2);
        }
        List<AnthropicMessage> messages = Collections.singletonList(new AnthropicMessage("user", prompt.streamPromptParts().map(text -> new AnthropicContent("text", (String)text)).toList()));
        AnthropicMessagesResponse response = (AnthropicMessagesResponse)Retrofit.executeServiceCall(this.service.performChatCompletion(new AnthropicMessagesRequest(maxTokens, this.model, messages, this.temperature, thinkingConfig))).orElseThrow(() -> new ServiceCallException("No response returned from LLM!"));
        if (this.usageReporter != null) {
            this.usageReporter.accept("input-tokens", Long.valueOf(response.usage.inputTokens));
            this.usageReporter.accept("output-tokens", Long.valueOf(response.usage.outputTokens));
        }
        StringBuilder result = new StringBuilder();
        for (AnthropicContent content : response.content()) {
            if (!"text".equals(content.type) || content.text == null) continue;
            result.append(content.text);
        }
        return result.toString();
    }

    private static interface IAnthropicService
    extends IRetrofitApi {
        @GET(value="models/{model}")
        public Call<AnthropicModelDescription> getModelDescription(@Path(value="model") String var1);

        @POST(value="messages")
        public Call<AnthropicMessagesResponse> performChatCompletion(@Body AnthropicMessagesRequest var1);
    }

    private record AnthropicThinking(String type, @JsonProperty(value="budget_tokens") int budgetTokens) {
    }

    private record AnthropicMessage(String role, List<AnthropicContent> content) {
    }

    private record AnthropicMessagesRequest(@JsonProperty(value="max_tokens") int maxTokens, String model, List<AnthropicMessage> messages, double temperature, AnthropicThinking thinking) {
    }

    private record AnthropicMessagesResponse(List<AnthropicContent> content, AnthropicUsage usage) {
    }

    private record AnthropicUsage(@JsonProperty(value="input_tokens") int inputTokens, @JsonProperty(value="output_tokens") int outputTokens) {
    }

    private record AnthropicContent(String type, String text) {
    }

    private record AnthropicModelDescription(String id, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="created_at") String createdAt, String type) {
    }
}

