/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public class OpenAiClient
implements ILlmCompleter {
    private static final String TEXT_CONTENT_TYPE = "text";
    private static final String BASE_URL = "https://api.openai.com/v1/";
    private static final Logger LOGGER = LogManager.getLogger();
    private final String model;
    private final IOpenAiService service;
    private final double temperature;
    private final @Nullable BiConsumer<String, Long> usageReporter;

    public OpenAiClient(String model, String apiKey, double temperature, @Nullable BiConsumer<String, Long> usageReporter) {
        this.model = model;
        this.service = OpenAiClient.createService(apiKey);
        this.temperature = temperature;
        this.usageReporter = usageReporter;
    }

    private static IOpenAiService createService(String apiKey) {
        return (IOpenAiService)Retrofit.builder((String)BASE_URL).withBearerAuthentication(apiKey).withInteractionLogger(LOGGER).create(IOpenAiService.class);
    }

    public Optional<String> getModelOwner() throws ServiceCallException {
        return Retrofit.executeServiceCall(this.service.getModelDescription(this.model)).map(OpenAiModelDescription::ownedBy);
    }

    @Override
    public String complete(LlmPrompt prompt) throws ServiceCallException {
        List<OpenAiChatMessage> requestMessage = Collections.singletonList(new OpenAiChatMessage("user", prompt.streamPromptParts().map(text -> new OpenAiTextContent(TEXT_CONTENT_TYPE, (String)text)).toList()));
        OpenAiChatResponse response = (OpenAiChatResponse)Retrofit.executeServiceCall(this.service.performChatCompletion(new OpenAiChatRequest(this.model, requestMessage, this.temperature))).orElseThrow(() -> new ServiceCallException("No response returned from LLM!"));
        if (this.usageReporter != null) {
            this.usageReporter.accept("input-tokens", Long.valueOf(response.usage.promptTokens));
            this.usageReporter.accept("output-tokens", Long.valueOf(response.usage.completionTokens));
        }
        return response.choices.getFirst().message.content;
    }

    private static interface IOpenAiService
    extends IRetrofitApi {
        @GET(value="models/{model}")
        public Call<OpenAiModelDescription> getModelDescription(@Path(value="model") String var1);

        @POST(value="chat/completions")
        public Call<OpenAiChatResponse> performChatCompletion(@Body OpenAiChatRequest var1);
    }

    private record OpenAiChatMessage(String role, List<OpenAiTextContent> content) {
    }

    private record OpenAiChatRequest(String model, List<OpenAiChatMessage> messages, double temperature) {
    }

    private record OpenAiChatResponse(List<OpenAiChatChoice> choices, OpenAiUsage usage) {
    }

    private record OpenAiUsage(@JsonProperty(value="completion_tokens") int completionTokens, @JsonProperty(value="prompt_tokens") int promptTokens, @JsonProperty(value="total_tokens") int totalTokens) {
    }

    private record OpenAiChatChoice(OpenAiResponseMessage message) {
    }

    private record OpenAiResponseMessage(String role, String content) {
    }

    private record OpenAiTextContent(String type, String text) {
    }

    private record OpenAiModelDescription(String id, String object, long created, @JsonProperty(value="owned_by") String ownedBy) {
    }
}

