/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdHintBasedOrderer;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class MetricThresholdGroup
extends NamedConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="metricThresholdList")
    private final List<MetricThreshold> metricThresholdList = new ArrayList<MetricThreshold>();

    @JsonCreator
    public MetricThresholdGroup(@JsonProperty(value="name") String name) {
        super(name);
    }

    public MetricThresholdGroup(String name, List<MetricThreshold> metricThresholds) {
        super(name);
        this.metricThresholdList.addAll(metricThresholds);
    }

    public UnmodifiableList<MetricThreshold> getMetricThresholdList() {
        return CollectionUtils.asUnmodifiable(this.metricThresholdList);
    }

    public MetricThreshold addMetricThreshold(String metricName) {
        MetricThreshold threshold = new MetricThreshold(metricName);
        this.metricThresholdList.add(threshold);
        return threshold;
    }

    public void addMetricThreshold(MetricThreshold metricThreshold) throws MetricThresholdConfigurationException {
        ArrayList<MetricThreshold> temp = new ArrayList<MetricThreshold>(this.metricThresholdList);
        temp.add(metricThreshold);
        this.validateDisplayNamesUnique(temp);
        this.metricThresholdList.add(metricThreshold);
    }

    public void addMetricThresholds(Collection<MetricThreshold> metricThresholds) {
        this.metricThresholdList.addAll(metricThresholds);
    }

    public Optional<MetricThreshold> findThresholdByDisplayName(String displayName) {
        CCSMAssert.isNotNull((Object)displayName);
        return this.metricThresholdList.stream().filter(threshold -> threshold.getDisplayName().equals(displayName)).findFirst();
    }

    public void validate() throws MetricThresholdConfigurationException {
        for (MetricThreshold metricThreshold : this.metricThresholdList) {
            metricThreshold.validate();
        }
        this.validateDisplayNamesUnique();
    }

    protected void validateDisplayNamesUnique() throws MetricThresholdConfigurationException {
        this.validateDisplayNamesUnique(this.metricThresholdList);
    }

    private void validateDisplayNamesUnique(List<MetricThreshold> metricThresholds) throws MetricThresholdConfigurationException {
        HashSet<String> displayNames = new HashSet<String>();
        for (MetricThreshold metricThreshold : metricThresholds) {
            boolean added = displayNames.add(metricThreshold.getDisplayName());
            if (added) continue;
            throw new MetricThresholdConfigurationException("The group '" + this.getName() + "' contains a threshold with a non-unique display name: " + metricThreshold.getDisplayName());
        }
    }

    public void adjustValues() {
        this.metricThresholdList.forEach(MetricThresholdBase::adjustValues);
    }

    public void reorderThresholdsBasedOnOrderHints() {
        if (this.metricThresholdList.isEmpty()) {
            return;
        }
        List<MetricThreshold> orderedThresholds = MetricThresholdHintBasedOrderer.order(this.metricThresholdList);
        this.metricThresholdList.clear();
        this.metricThresholdList.addAll(orderedThresholds);
    }
}

