/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public class AnalysisGroupDescriptor {
    @JsonProperty(value="name")
    private final String name;
    @JsonIgnore
    private final Map<String, ConfigurationItemBase> configItemsByName = new HashMap<String, ConfigurationItemBase>();
    @JsonProperty(value="configItems")
    @Schema(implementation=ConfigItems.class)
    private final List<ConfigurationItemBase> configItems = new ArrayList<ConfigurationItemBase>();
    @JsonProperty(value="unconfiguredChecks")
    private PairList<String, String> unconfiguredChecks = new PairList();
    @JsonProperty(value="registered")
    private boolean registered = false;

    public AnalysisGroupDescriptor(String name, ConfigurationItemBase ... items) {
        this.name = name;
        for (ConfigurationItemBase item : items) {
            this.add(item);
        }
    }

    public String getName() {
        return this.name;
    }

    public void add(ConfigurationItemBase item) {
        this.checkAlreadyExists(item.getName());
        this.configItemsByName.put(item.getName(), item);
        this.configItems.add(item);
    }

    public void insert(ConfigurationItemBase configurationItem, int position) {
        this.checkAlreadyExists(configurationItem.getName());
        this.configItemsByName.put(configurationItem.getName(), configurationItem);
        this.configItems.add(position, configurationItem);
    }

    private void checkAlreadyExists(String name) {
        CCSMAssert.isFalse((boolean)this.configItemsByName.containsKey(name), (String)("Duplicate config item \"" + name + "\" in analysis group \"" + this.getName() + "\""));
    }

    public void replaceItem(ConfigurationItemBase oldItem, ConfigurationItemBase newItem) {
        String oldName = oldItem.getName();
        String newName = newItem.getName();
        CCSMAssert.isTrue((boolean)oldName.equals(newName), (String)("Trying to replace config item \"" + oldName + "\" with \"" + newName + "\" in analysis group \"" + this.getName() + "\". Both config items must have the same name."));
        int index = this.configItems.indexOf(oldItem);
        this.configItems.set(index, newItem);
        this.configItemsByName.replace(newName, oldItem, newItem);
    }

    public UnmodifiableList<ConfigurationItemBase> getConfigurationItems() {
        return CollectionUtils.asUnmodifiable(this.configItems);
    }

    public @Nullable ConfigurationItemBase getConfigurationItem(String name) {
        return this.configItemsByName.get(name);
    }

    public Collection<AnalysisConfigurationBase> getReferencedConfigurations(Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        IdentityHashSet configurations = new IdentityHashSet();
        for (ConfigurationItemBase configItem : this.configItemsByName.values()) {
            if (!configItem.requiredToolPresent(tools)) continue;
            ConfigurationBase configuration = configItem.getConfiguration();
            if (configuration instanceof AnalysisConfigurationBase) {
                configurations.add((AnalysisConfigurationBase)configuration);
                continue;
            }
            throw new ProjectConfigurationException("Config item returned non-analysis configuration!");
        }
        return configurations;
    }

    boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered() {
        this.registered = true;
    }

    public void addUnconfiguredCheck(String checkName, String checkReadableName) {
        this.unconfiguredChecks.add((Object)checkName, (Object)checkReadableName);
    }

    public PairList<String, String> getUnconfiguredChecks() {
        return this.unconfiguredChecks;
    }

    public boolean isActive() {
        return this.configItems.stream().anyMatch(ConfigurationItemBase::isActive);
    }

    public String toString() {
        return this.name;
    }

    @ArraySchema(schema=@Schema(implementation=ConfigItem.class))
    public static interface ConfigItems
    extends List<ConfigItem> {
    }

    @Schema(oneOf={ConfigOptionDescriptorBase.class, FindingDescriptor.class, MetricDescriptor.class})
    public static interface ConfigItem {
    }
}

