/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class RollbackRequestedCommitDescriptor
extends RichCommitDescriptor {
    private static final String ROLLBACK_REQUEST_BRANCH_NAME = "###rollback-to###";
    public static final CommitDescriptor ROLLBACK_REQUESTED_COMMIT = new CommitDescriptor("###rollback-to###", 1L);
    private static final long serialVersionUID = 1L;
    private final UUID rollbackId;
    private final String rollbackReason;
    private boolean neverPostpone = false;

    public RollbackRequestedCommitDescriptor(List<CommitDescriptor> rollbackCommits, String rollbackReason) {
        this(rollbackCommits, rollbackReason, UUID.randomUUID());
    }

    public RollbackRequestedCommitDescriptor(List<CommitDescriptor> rollbackCommits, String rollbackReason, UUID rollbackId) {
        super(ROLLBACK_REQUESTED_COMMIT, Collections.emptyList(), rollbackCommits, Collections.emptyList());
        this.rollbackReason = rollbackReason;
        this.rollbackId = rollbackId;
    }

    public String getRollbackReason() {
        return this.rollbackReason;
    }

    public boolean mayNotBePostponed() {
        return this.neverPostpone;
    }

    public void setMayNotBePostponed(boolean neverPostpone) {
        this.neverPostpone = neverPostpone;
    }

    public UUID getRollbackId() {
        return this.rollbackId;
    }

    public static Optional<UUID> getRollbackId(CommitDescriptor commitDescriptor) {
        if (commitDescriptor instanceof RollbackRequestedCommitDescriptor) {
            return Optional.ofNullable(((RollbackRequestedCommitDescriptor)commitDescriptor).getRollbackId());
        }
        return Optional.empty();
    }
}

