/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.committree;

import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;

public class CommitTreeRevision
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String revision;
    private String branchName;

    public CommitTreeRevision(String revision, String branchName) {
        this.revision = revision;
        this.branchName = branchName;
    }

    public CommitTreeRevision(long revision, String branchName) {
        this(String.valueOf(revision), branchName);
    }

    public String getRevision() {
        return this.revision;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public int hashCode() {
        return Objects.hash(this.revision, this.branchName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommitTreeRevision)) {
            return false;
        }
        CommitTreeRevision other = (CommitTreeRevision)obj;
        return Objects.equals(this.revision, other.revision) && Objects.equals(this.branchName, other.branchName);
    }

    public String toString() {
        return this.revision + "@" + this.branchName;
    }

    public byte[] toStorageKey() {
        return StringUtils.stringToBytes((String)(this.branchName + ":" + this.revision));
    }

    public static CommitTreeRevision fromStorageKey(byte[] storageKey) {
        String[] keyParts = StringUtils.bytesToString((byte[])storageKey).split(":");
        return new CommitTreeRevision(keyParts[1], keyParts[0]);
    }
}

