/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexCrawler;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class GlobalSchemaRegistry {
    private static GlobalSchemaRegistry instance = null;
    private final Map<String, SchemaEntry> entries = new HashMap<String, SchemaEntry>();

    private GlobalSchemaRegistry() {
        this.registerGlobalIndex(MetaIndex.class);
        this.registerGlobalIndices(IndexCrawler.collectGlobalIndices());
    }

    public static synchronized GlobalSchemaRegistry getInstance() {
        if (instance == null) {
            instance = new GlobalSchemaRegistry();
        }
        return instance;
    }

    private synchronized void registerGlobalIndices(Collection<Class<? extends IGlobalIndex>> globalIndices) {
        globalIndices.stream().filter(globalIndex -> globalIndex != MetaIndex.class).forEach(this::registerGlobalIndex);
    }

    private synchronized void registerGlobalIndex(Class<? extends IGlobalIndex> indexClass) {
        Index indexAnnotation = IStorageIndex.getIndexAnnotation(indexClass);
        String indexName = indexAnnotation.name();
        if (this.entries.containsKey(indexName)) {
            CCSMAssert.isTrue((boolean)this.entries.get(indexName).getIndexClass().equals(indexClass.getName()), (String)("Trying to register two global indices with the same name " + indexName + " (" + this.entries.get(indexName).getIndexClass() + " and " + indexClass.getName() + ")"));
            return;
        }
        this.entries.put(indexName, new SchemaEntry(indexClass, indexAnnotation));
    }

    public synchronized IndexSchema getSchema() {
        IndexSchema.Builder schemaBuilder = IndexSchema.builder();
        for (Map.Entry<String, SchemaEntry> entry : this.entries.entrySet()) {
            schemaBuilder.updateWithSchemaEntry(entry.getKey(), entry.getValue());
        }
        return schemaBuilder.build();
    }
}

