/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.teamscale.core.metrics.directory.MetricsSerializationUtils;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="(dynamic)", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={byte[].class})
public class MetricTrendIndex
extends TrendIndexBase<Object[]>
implements IProjectIndexWithDynamicName {
    public static final String INDEX_NAME = "metric-trend";
    private String indexInstanceName;

    public MetricTrendIndex(IStore store) {
        super(store);
    }

    public String getName() {
        return this.indexInstanceName;
    }

    public void setName(String indexInstanceName) {
        this.indexInstanceName = indexInstanceName;
    }

    @Override
    protected Object[] bytesToValue(byte[] value) throws StorageException {
        Object[] objectArray;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value));
        try {
            objectArray = MetricsSerializationUtils.readObjectArray(dis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        dis.close();
        return objectArray;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] valueToBytes(Object[] value) throws StorageException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                MetricsSerializationUtils.writeObjectArray(value, dos);
                dos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }
}

