/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedArrayObject;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public abstract class MigrateVersion145CompactLinesBase
extends BranchBasedStoreBatchMigratorBase {
    private static final String LINE_COVERAGE_INFO_CLASS = "org.conqat.engine.sourcecode.coverage.LineCoverageInfo";
    private static final String COMPACT_LINES_CLASS = "org.conqat.lib.commons.collections.CompactLines";
    private static final String MULTI_FILE_RANGE_COVERAGE_CLASS = "org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo";

    protected MigrateVersion145CompactLinesBase() {
        super(EStorageSystemVersion.STORAGE_SYSTEM_V145, true);
    }

    @Override
    protected byte[] migrateValue(byte[] key, byte[] value) throws StorageException {
        try {
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            MigrateVersion145CompactLinesBase.migrateLineCoverageInfos(entityPool);
            MigrateVersion145CompactLinesBase.migrateMultiFileRangeCoverageInfos(entityPool);
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static void migrateLineCoverageInfos(SerializedEntityPool entityPool) throws IOException {
        SerializedClass lineCoverageInfoClass = entityPool.findClass(LINE_COVERAGE_INFO_CLASS);
        if (lineCoverageInfoClass == null) {
            return;
        }
        MigrateVersion145CompactLinesBase.migrateHashSetField(entityPool, lineCoverageInfoClass, "fullyCoveredLines");
        MigrateVersion145CompactLinesBase.migrateHashSetField(entityPool, lineCoverageInfoClass, "partiallyCoveredLines");
        MigrateVersion145CompactLinesBase.migrateHashSetField(entityPool, lineCoverageInfoClass, "uncoveredLines");
        entityPool.removeClassIfUnused("java.util.HashSet");
        entityPool.removeClassIfUnused("java.lang.Integer");
        entityPool.removeClassIfUnused("java.lang.Number");
    }

    private static void migrateHashSetField(SerializedEntityPool entityPool, SerializedClass lineCoverageInfoClass, String fieldName) throws IOException {
        int compactLinesClass = MigrateVersion145CompactLinesBase.getOrCreateCompactLinesClass(entityPool);
        String tempFieldName = "tmp" + fieldName;
        lineCoverageInfoClass.renameField(fieldName, tempFieldName);
        lineCoverageInfoClass.addField((SerializedFieldBase)new SerializedObjectField(fieldName, SerializedObjectField.createJvmNotationFromPlainClassName((String)COMPACT_LINES_CLASS)));
        List coverageInfos = SerializedEntityUtils.findInstancesOf((SerializedClass)lineCoverageInfoClass, (SerializedEntityPool)entityPool);
        for (SerializedObject coverageInfo : coverageInfos) {
            Integer hashSetHandle = (Integer)coverageInfo.getFieldValue(tempFieldName);
            BitSet bitSet = MigrateVersion145CompactLinesBase.convertHashSetToBitSetAndRemove(entityPool, hashSetHandle);
            coverageInfo.setFieldValue(fieldName, (Object)MigrateVersion145CompactLinesBase.createCompactLines(bitSet, compactLinesClass, entityPool).getHandle());
        }
        new SerializedClassFieldMigrator(entityPool).removeField(LINE_COVERAGE_INFO_CLASS, tempFieldName);
    }

    private static int getOrCreateCompactLinesClass(SerializedEntityPool entityPool) {
        SerializedClass compactLinesClass = entityPool.findClass(COMPACT_LINES_CLASS);
        if (compactLinesClass == null) {
            compactLinesClass = new SerializedClass(COMPACT_LINES_CLASS, 1L, 3, entityPool);
        }
        return compactLinesClass.getHandle();
    }

    private static void migrateMultiFileRangeCoverageInfos(SerializedEntityPool entityPool) throws IOException {
        SerializedClass multiFileRangeCoverageClass = entityPool.findClass(MULTI_FILE_RANGE_COVERAGE_CLASS);
        if (multiFileRangeCoverageClass == null) {
            return;
        }
        int compactLinesClass = MigrateVersion145CompactLinesBase.getOrCreateCompactLinesClass(entityPool);
        List multiFileRangeCoverages = SerializedEntityUtils.findInstancesOf((SerializedClass)multiFileRangeCoverageClass, (SerializedEntityPool)entityPool);
        for (SerializedObject multiFileRangeCoverage : multiFileRangeCoverages) {
            SerializedClassValues fieldSet = multiFileRangeCoverage.getFieldSet(0);
            List preFieldData = fieldSet.getPreFieldData();
            for (int i = 0; i < preFieldData.size(); ++i) {
                Object preFieldValue = preFieldData.get(i);
                if (!(preFieldValue instanceof Integer)) continue;
                Integer intListHandle = (Integer)preFieldValue;
                BitSet bitSet = MigrateVersion145CompactLinesBase.getIntListAsBitSet(intListHandle, entityPool);
                SerializedObject compactLines = MigrateVersion145CompactLinesBase.createCompactLines(bitSet, compactLinesClass, entityPool);
                preFieldData.set(i, compactLines.getHandle());
            }
        }
        entityPool.removeClassIfUnused("org.conqat.lib.commons.collections.IntList");
        entityPool.removeClassIfUnused("org.conqat.lib.commons.collections.ManagedIntArray");
        entityPool.removeClassIfUnused("[I");
    }

    private static BitSet getIntListAsBitSet(Integer intListHandle, SerializedEntityPool entityPool) throws IOException {
        SerializedObject intList = (SerializedObject)entityPool.getEntity(intListHandle.intValue(), SerializedObject.class);
        Integer size = (Integer)intList.getFieldValue("size");
        Integer arrayHandle = (Integer)intList.getFieldValue("array");
        SerializedArrayObject array = (SerializedArrayObject)entityPool.getEntity(arrayHandle.intValue(), SerializedArrayObject.class);
        BitSet bitSet = new BitSet();
        for (int i = 0; i < size; ++i) {
            Integer line = (Integer)array.getValue(i);
            bitSet.set(line);
        }
        entityPool.removeEntity((SerializedEntityBase)intList);
        return bitSet;
    }

    private static @NonNull SerializedObject createCompactLines(BitSet bitSet, int compactLinesClass, SerializedEntityPool entityPool) {
        byte[] compactLinesAsBitArray = bitSet.toByteArray();
        SerializedClassValues fieldSet = new SerializedClassValues(compactLinesAsBitArray.length);
        fieldSet.appendData((Object)compactLinesAsBitArray, true);
        return new SerializedObject(compactLinesClass, List.of(fieldSet), entityPool);
    }

    private static BitSet convertHashSetToBitSetAndRemove(SerializedEntityPool entityPool, Integer hashSetHandle) throws IOException {
        SerializedObject hashSetObject = (SerializedObject)entityPool.getEntity(hashSetHandle.intValue(), SerializedObject.class);
        BitSet bitSet = new BitSet();
        SerializedClassValues fieldSets = hashSetObject.getFieldSet(0);
        for (Object data : fieldSets.getPreFieldData()) {
            SerializedEntityBase containedElement;
            if (!(data instanceof Integer) || !((containedElement = entityPool.getEntity(((Integer)data).intValue(), SerializedEntityBase.class)) instanceof SerializedObject)) continue;
            SerializedObject containedInt = (SerializedObject)containedElement;
            Integer value = (Integer)containedInt.getFieldValue("value");
            bitSet.set(value);
            entityPool.removeEntity((SerializedEntityBase)containedInt);
        }
        entityPool.removeEntity((SerializedEntityBase)hashSetObject);
        return bitSet;
    }
}

