/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedBooleanField;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion162AddHideMetricBadgeParameter
extends ReportSlideMigratorBase {
    private static final String METRIC_TREEMAP_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.MetricTreemapSlide";
    private static final String METRIC_TREEMAP_PARAMETERS_CLASS = "com.teamscale.index.quality_report.slides.MetricTreemapSlide$MetricTreemapSlideParameters";
    private static final String HIDE_METRIC_BADGE_PARAMETER_NAME = "hideMetricBadge";

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        this.addHideMetricBadgeToMetricTreemapSlides(entityPool, METRIC_TREEMAP_SLIDE_CLASS, METRIC_TREEMAP_PARAMETERS_CLASS);
    }

    private void addHideMetricBadgeToMetricTreemapSlides(SerializedEntityPool entityPool, String slideClass, String slideParameterClass) throws IOException {
        SerializedClass serializedParameterClass = entityPool.findClass(slideParameterClass);
        if (serializedParameterClass != null && !serializedParameterClass.containsField(HIDE_METRIC_BADGE_PARAMETER_NAME)) {
            serializedParameterClass.addField((SerializedFieldBase)new SerializedBooleanField(HIDE_METRIC_BADGE_PARAMETER_NAME));
        }
        for (SerializedObject slide : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(slideClass), (SerializedEntityPool)entityPool)) {
            SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)slide.getFieldValue("slideParameters")).intValue(), SerializedObject.class);
            slideParameters.setFieldValue(HIDE_METRIC_BADGE_PARAMETER_NAME, (Object)true);
        }
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V162;
    }
}

