/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion180RemoveTrackedFinding
extends SerializedValueMigratorBase {
    private static final byte[] VALUE_INDEX_PREFIX = StringUtils.stringToBytes((String)"v");
    private static final byte[] SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX = StringUtils.stringToBytes((String)"$%$e$%$");

    public MigrateVersion180RemoveTrackedFinding() {
        super(true);
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V180;
    }

    @Override
    protected boolean isHiddenKey(byte[] key) {
        return super.isHiddenKey(key) || !MigrateVersion180RemoveTrackedFinding.isKeyToMigrate(key);
    }

    private static boolean isKeyToMigrate(byte[] key) {
        return ByteArrayUtils.isPrefix((byte[])VALUE_INDEX_PREFIX, (byte[])key) && ByteArrayUtils.contains((byte[])SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX, (byte[])key);
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass trackedFindingClass = entityPool.findClass("org.conqat.engine.index.shared.TrackedFinding");
        if (trackedFindingClass == null) {
            return;
        }
        List trackedFindingEntities = entityPool.getEntities(trackedFindingClass);
        for (SerializedObject trackedFindingEntity : trackedFindingEntities) {
            trackedFindingEntity.removeFieldSet(trackedFindingEntity.getFieldSetCount() - 1);
            trackedFindingEntity.setClassHandle(trackedFindingClass.getSuperClassHandle());
        }
    }

    @Override
    public String getStoreName() {
        return "external-analysis-session";
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.PROJECT;
    }
}

