/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.option.CustomTypeOption;
import com.teamscale.core.option.DateOption;
import com.teamscale.core.option.EOptionParameterType;
import com.teamscale.core.option.HashedPasswordOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import com.teamscale.core.option.ScheduleOption;
import java.lang.reflect.Field;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class OptionParameterDescriptor {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="type")
    private final EOptionParameterType type;
    @JsonProperty(value="dependentOptions")
    private final String[] dependentOptions;
    @JsonProperty(value="hidden")
    private final boolean hidden;

    public OptionParameterDescriptor(Field field) {
        this.id = OptionParameterDescriptor.getId(field);
        this.type = OptionParameterDescriptor.getParameterType(field);
        if (this.type == null) {
            CCSMAssert.fail((String)("Fields in options must be String, int, long (only if ADateOption), double, or boolean: " + String.valueOf(field)));
        }
        CCSMAssert.isTrue((boolean)field.isAnnotationPresent(OptionFieldDescription.class), (String)("Option fields must be annotated with " + OptionFieldDescription.class.getSimpleName() + ": " + String.valueOf(field)));
        OptionFieldDescription annotation = field.getAnnotation(OptionFieldDescription.class);
        this.name = annotation.name();
        this.description = annotation.description();
        this.dependentOptions = annotation.dependentOptions();
        this.hidden = annotation.hidden();
    }

    private static String getId(Field field) {
        CCSMAssert.isTrue((boolean)field.isAnnotationPresent(JsonProperty.class), (String)("Option fields must be annotated with " + JsonProperty.class.getSimpleName() + ": " + String.valueOf(field)));
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        String value = jsonProperty.value();
        if (StringUtils.isEmpty((String)value)) {
            return field.getName();
        }
        return value;
    }

    private static EOptionParameterType getParameterType(Field field) {
        if (field.isAnnotationPresent(CustomTypeOption.class)) {
            return EOptionParameterType.CUSTOM;
        }
        Class<?> type = field.getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            return EOptionParameterType.BOOLEAN;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return EOptionParameterType.INTEGER;
        }
        if (type == Double.TYPE || type == Double.class) {
            return EOptionParameterType.DOUBLE;
        }
        if (type == String.class) {
            if (field.isAnnotationPresent(DateOption.class)) {
                return EOptionParameterType.DATE;
            }
            if (field.isAnnotationPresent(PasswordOption.class) || field.isAnnotationPresent(HashedPasswordOption.class)) {
                return EOptionParameterType.PASSWORD;
            }
            if (field.isAnnotationPresent(ScheduleOption.class)) {
                return EOptionParameterType.SCHEDULE;
            }
            if (field.isAnnotationPresent(MultilineOption.class)) {
                return EOptionParameterType.MULTILINE;
            }
            return EOptionParameterType.STRING;
        }
        if (type == PairList.class) {
            return EOptionParameterType.PAIRLIST;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDependentOptions() {
        return this.dependentOptions;
    }

    public EOptionParameterType getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

