/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import java.time.Duration;
import java.util.Map;
import org.jetbrains.annotations.TestOnly;

public class HttpRequestRetryStepParameters {
    private static final String CONNECTION_FAILURE_RETRY_PARAMETER = "timeout-retry";
    private static final String CONNECTION_FAILURE_RETRY_DELAY_PARAMETER = "timeout-retry-delay";
    @StepParameter(value="timeout-retry", optional=true)
    private int numberOfTimeoutRetries = -1;
    @StepParameter(value="timeout-retry-delay", optional=true)
    private long initialRetryDelayInMillis = -1L;
    private final HttpRequestRetryPolicy fallbackRetryPolicy;

    public HttpRequestRetryStepParameters() {
        this.fallbackRetryPolicy = HttpRequestRetryPolicy.SYSTEM_DEFAULT;
    }

    public HttpRequestRetryStepParameters(HttpRequestRetryPolicy fallbackRetryPolicy) {
        this.fallbackRetryPolicy = fallbackRetryPolicy;
    }

    @TestOnly
    public static void addStepParametersForTesting(Map<String, Object> parameters, HttpRequestRetryPolicy retryPolicy) {
        parameters.put(CONNECTION_FAILURE_RETRY_PARAMETER, retryPolicy.getNumberOfRetries());
        parameters.put(CONNECTION_FAILURE_RETRY_DELAY_PARAMETER, retryPolicy.initialDelay.toMillis());
    }

    public HttpRequestRetryPolicy createRetryPolicy() {
        if (this.numberOfTimeoutRetries >= 0 && this.initialRetryDelayInMillis >= 0L) {
            return new HttpRequestRetryPolicy(this.numberOfTimeoutRetries, Duration.ofMillis(this.initialRetryDelayInMillis));
        }
        return this.fallbackRetryPolicy;
    }
}

