/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

public class JobExecutionResult {
    private final EJobResult result;
    private final CommitDescriptor outputCommit;
    private final PairList<String, Long> outputDeltas;
    private final Map<String, Long> virtualStores;
    private final long rescheduleAfterTimestamp;

    public JobExecutionResult(EJobResult result) {
        this(result, null);
    }

    public JobExecutionResult(EJobResult result, CommitDescriptor outputCommit) {
        this(result, outputCommit, null, null, 0L);
    }

    public JobExecutionResult(EJobResult result, CommitDescriptor outputCommit, @Nullable PairList<String, Long> outputDeltas, @Nullable Map<String, Long> virtualStores, long rescheduleAfterTimestamp) {
        if (result == EJobResult.ROLLBACK_REQUESTED && outputCommit == null) {
            throw new IllegalArgumentException("Output commit cannot be null for ROLLBACK_REQUESTED");
        }
        this.result = result;
        this.outputCommit = outputCommit;
        this.outputDeltas = Objects.requireNonNullElseGet(outputDeltas, PairList::new);
        this.virtualStores = Objects.requireNonNullElse(virtualStores, Collections.emptyMap());
        this.rescheduleAfterTimestamp = rescheduleAfterTimestamp;
    }

    public EJobResult getResult() {
        return this.result;
    }

    public CommitDescriptor getOutputCommit() {
        return this.outputCommit;
    }

    public PairList<String, Long> getOutputDeltas() {
        return this.outputDeltas;
    }

    public long getRescheduleAfterTimestamp() {
        return this.rescheduleAfterTimestamp;
    }

    public Optional<Long> getVirtualStoreId(String storeName) {
        return Optional.ofNullable(this.virtualStores.get(storeName));
    }

    public boolean isDeleted() {
        return this.result == EJobResult.COMPLETED_WITH_PROJECT_DELETION;
    }

    public String toString() {
        return "JobExecutionResult{result=" + String.valueOf((Object)this.result) + ", outputCommit=" + String.valueOf(this.outputCommit) + ", outputDeltas=" + String.valueOf(this.outputDeltas) + "}";
    }

    public static enum EJobResult {
        COMPLETED_SUCCESSFULLY,
        COMPLETED_WITH_PROJECT_DELETION,
        COMPLETED_WITH_ERROR,
        COMPLETED_WITH_UNRECOVERABLE_ERROR,
        RESCHEDULE_REQUESTED,
        ROLLBACK_REQUESTED;

    }
}

