/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.OptionScheduledRunnable;
import com.teamscale.core.option.ScheduleOptionUtils;
import com.teamscale.core.runtime.impl.scheduling.PeriodicSchedulingData;
import com.teamscale.core.shutdown.ShutdownManagerAwareThread;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.SetMap;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public final class OptionScheduledRunnersSchedulerThread
extends ShutdownManagerAwareThread {
    private static final IntSupplier THREAD_INDEX_FACTORY = new AtomicInteger()::getAndIncrement;
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final Duration SLEEP_DURATION = Duration.ofMillis(200L);
    private static final Set<Class<? extends OptionScheduledRunnable>> RUNNING_ELEMENTS = Collections.synchronizedSet(new HashSet());
    private final PeriodicSchedulingData periodicSchedulingData = new PeriodicSchedulingData();
    private final ExecutorService executorService;
    private final IndexLayer indexLayer;

    public OptionScheduledRunnersSchedulerThread(IndexLayer indexLayer) {
        this.indexLayer = indexLayer;
        int threadIndex = THREAD_INDEX_FACTORY.getAsInt();
        this.executorService = OptionScheduledRunnersSchedulerThread.instantiateExecutorService(threadIndex);
        this.setName("Teamscale Option Scheduled Runner Scheduler " + threadIndex);
        this.setDaemon(true);
    }

    private static ExecutorService instantiateExecutorService(final int threadIndex) {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            private final IntSupplier runnerThreadIndexFactory = new AtomicInteger()::getAndIncrement;

            @Override
            public Thread newThread(@NonNull Runnable r) {
                Thread result = new Thread(r, "Teamscale Option Scheduled Runner %d_%d".formatted(threadIndex, this.runnerThreadIndexFactory.getAsInt()));
                result.setDaemon(true);
                return result;
            }
        });
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            this.executorService.shutdown();
        }
    }

    @Override
    protected void loop() {
        try {
            Thread.sleep(SLEEP_DURATION.toMillis());
        }
        catch (InterruptedException e) {
            this.prepareExit();
            return;
        }
        for (int periodicSchedulingTick : this.periodicSchedulingData.getPeriodicSchedulingTicks()) {
            this.scheduleRunners(periodicSchedulingTick);
        }
    }

    private void scheduleRunners(int timeSeconds) {
        if (timeSeconds % 60 != 0) {
            return;
        }
        List<OptionScheduledRunnable> scheduledRunners = this.getScheduledRunners((long)timeSeconds * 1000L);
        for (OptionScheduledRunnable scheduledRunner : scheduledRunners) {
            if (!RUNNING_ELEMENTS.add(scheduledRunner.getClass())) continue;
            this.executorService.submit(() -> {
                try {
                    scheduledRunner.run();
                }
                catch (Exception e) {
                    LOGGER.error("Got uncaught exception while running: {}", (Object)scheduledRunner, (Object)e);
                }
                finally {
                    RUNNING_ELEMENTS.remove(scheduledRunner.getClass());
                }
            });
        }
    }

    private List<OptionScheduledRunnable> getScheduledRunners(long timestamp) {
        SetMap<String, Class<? extends OptionScheduledRunnable>> optionsWithScheduledRunnableClasses;
        try {
            optionsWithScheduledRunnableClasses = ScheduleOptionUtils.getOptionScheduledRunnables(timestamp, this.indexLayer);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to load scheduled runners", (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<OptionScheduledRunnable> result = new ArrayList<OptionScheduledRunnable>();
        for (Map.Entry optionWithScheduledRunnableClasses : optionsWithScheduledRunnableClasses) {
            String optionName = (String)optionWithScheduledRunnableClasses.getKey();
            for (Class scheduledRunnableClass : (Set)optionWithScheduledRunnableClasses.getValue()) {
                try {
                    result.add((OptionScheduledRunnable)OptionScheduledRunnable.createInstance(scheduledRunnableClass, optionName, this.indexLayer));
                }
                catch (ReflectiveOperationException e) {
                    LOGGER.error("Unable to create OptionScheduledRunnable instance {} for option: {}", (Object)scheduledRunnableClass, (Object)optionName, (Object)e);
                }
            }
        }
        return result;
    }
}

