/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public class WorkerThreadProfilingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String workerId;
    private final WorkerClusterStatus.WorkerThreadStatus threadStatus;
    private String phaseName;
    private PublicProjectId projectId;
    private long startTimestamp;
    private final IndexLayer indexLayer;

    public WorkerThreadProfilingHelper(String workerId, WorkerClusterStatus.WorkerThreadStatus threadStatus, IndexLayer indexLayer) {
        this.workerId = workerId;
        this.threadStatus = threadStatus;
        this.indexLayer = indexLayer;
    }

    public void startPhase(String phaseName, PublicProjectId projectId) {
        this.phaseName = phaseName;
        this.projectId = projectId;
        this.startTimestamp = System.currentTimeMillis();
        this.threadStatus.startTask(projectId, phaseName, null, false);
    }

    public void reportError(Throwable e) {
        LOGGER.error("Critical error during " + this.phaseName + " (project: " + String.valueOf(this.projectId) + ", worker: " + this.workerId + "): " + e.getMessage(), e);
    }

    public void endPhase(boolean logDetails) {
        this.threadStatus.clear();
        if (logDetails) {
            long durationMillis = System.currentTimeMillis() - this.startTimestamp;
            PublicProjectId projectId = Optional.ofNullable(this.projectId).orElse(SchedulingConstants.MAINTENANCE_PROJECT_PUBLIC_NAME);
            try {
                PerformanceIndexBase performanceIndex = PerformanceIndexBase.open(this.indexLayer, (IProjectId)projectId);
                PerformanceDetailEntry entry = new PerformanceDetailEntry(EAnalysisState.LIVE_ANALYSIS, "Scheduling: " + this.phaseName, projectId, null, new PerformanceDetailEntry.WorkerPerformanceData(this.workerId, Instant.ofEpochMilli(this.startTimestamp), Duration.ofMillis(durationMillis), 0L), Collections.emptyList(), 0L, 0L);
                performanceIndex.addDetailEntry(entry);
            }
            catch (StorageException e) {
                LOGGER.error("Failed to persist performance data: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setProjectId(PublicProjectId projectId) {
        this.projectId = projectId;
    }
}

