/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.spi;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.core.spi.ITeamscaleService;
import com.teamscale.core.spi.Vetoed;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ServiceConfigurationError;
import java.util.stream.Stream;

public class TeamscaleServiceLoader {
    public static <T extends ITeamscaleService> T loadExactlyOne(Class<T> clazz) throws ServiceConfigurationError {
        return (T)((ITeamscaleService)TeamscaleServiceLoader.loadAll(clazz).reduce((t1, t2) -> {
            throw new ServiceConfigurationError("Found multiple implementations (%s, %s) of %s on the classpath!".formatted(t1.getClass(), t2.getClass(), clazz));
        }).orElseThrow(() -> new ServiceConfigurationError("Found no implementations of %s!".formatted(clazz))));
    }

    public static <T extends ITeamscaleService> Stream<T> loadAll(Class<T> clazz) throws ServiceConfigurationError {
        return TeamscaleServiceLoader.getConcreteSubclasses(clazz).map(TeamscaleServiceLoader::getInstance);
    }

    private static <T extends ITeamscaleService> Stream<Class<? extends T>> getConcreteSubclasses(Class<T> clazz) {
        return ClassIndexUtils.getConcreteSubclasses(ITeamscaleService.class).filter(c -> !c.isAnnotationPresent(Vetoed.class)).filter(clazz::isAssignableFrom).map(c -> c.asSubclass(clazz));
    }

    private static <T extends ITeamscaleService> T getInstance(Class<T> clazz) throws ServiceConfigurationError {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor.getModifiers())) {
                throw new ServiceConfigurationError("%s has no non-private no-args constructor".formatted(clazz));
            }
            constructor.setAccessible(true);
            return (T)((ITeamscaleService)constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceConfigurationError("Failed to initialize instance of type: %s".formatted(clazz), e);
        }
    }
}

