/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="project-user-activity", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP}, valueClasses={String.class})
public class ProjectUserActivityIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "project-user-activity";
    private static final byte[] SEPARATOR = new byte[]{0};

    public ProjectUserActivityIndex(IStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordActivity(PublicProjectId project, Collection<String> usernames, long timestamp) throws StorageException {
        long timestampAtStartOfDay = ProjectUserActivityIndex.truncateToStartOfDay(Instant.ofEpochMilli(timestamp));
        byte[] key = ProjectUserActivityIndex.makeKey(timestampAtStartOfDay, project);
        Lock lock = this.store.obtainLock(project.toString());
        try {
            lock.lock();
            HashSet<String> value = ProjectUserActivityIndex.deserialize(this.store.get(key));
            value.addAll(ProjectUserActivityIndex.anonymize(usernames));
            this.store.put(key, StorageUtils.serialize(value));
        }
        finally {
            lock.unlock();
        }
    }

    private static Collection<String> anonymize(Collection<String> usernames) {
        return CollectionUtils.map(usernames, Digester::createMD5Digest);
    }

    private static byte[] makeKey(long timestamp, PublicProjectId project) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)project.toString()), SEPARATOR, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    private static long truncateToStartOfDay(Instant timestamp) {
        return timestamp.truncatedTo(ChronoUnit.DAYS).toEpochMilli();
    }

    public Integer getNumberOfUniqueUsers(List<PublicProjectId> projects, Instant startTimestamp, Instant endTimestamp, Set<String> excludedUsers) throws StorageException {
        HashSet<String> uniqueUsers = new HashSet<String>();
        for (PublicProjectId project : projects) {
            uniqueUsers.addAll(this.getUniqueUsers(project, startTimestamp, endTimestamp));
        }
        uniqueUsers.removeAll(ProjectUserActivityIndex.anonymize(excludedUsers));
        return uniqueUsers.size();
    }

    public Set<String> getUniqueUsers(PublicProjectId project, Instant startTimestamp, Instant endTimestamp) throws StorageException {
        byte[] startKey = ProjectUserActivityIndex.makeKey(ProjectUserActivityIndex.truncateToStartOfDay(startTimestamp), project);
        byte[] endKey = ProjectUserActivityIndex.makeKey(ProjectUserActivityIndex.truncateToStartOfDay(endTimestamp) - 1L, project);
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(startKey, endKey, (IKeyValueCallback)callback);
        return CollectionUtils.unionSetAll((Collection)callback.getResultOrThrowException());
    }

    private static HashSet<String> deserialize(byte[] valueBytes) throws StorageException {
        if (valueBytes == null) {
            return new HashSet<String>();
        }
        return (HashSet)StorageUtils.deserialize((byte[])valueBytes);
    }

    public void purgeEntriesOlderThan(Instant thresholdTimestamp) throws StorageException {
        List keys = StorageUtils.listKeys((IStore)this.store);
        List keysToDelete = CollectionUtils.filter((Collection)keys, key -> ProjectUserActivityIndex.hasTimestampOlderThan(key, thresholdTimestamp));
        this.store.remove(keysToDelete);
    }

    private static boolean hasTimestampOlderThan(byte[] key, Instant thresholdTimestamp) {
        byte[] timestampBytes = Arrays.copyOfRange(key, key.length - 8, key.length);
        Instant timestamp = Instant.ofEpochMilli(ByteArrayUtils.byteArrayToLong((byte[])timestampBytes));
        return timestamp.isBefore(thresholdTimestamp);
    }
}

