/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.teamscale.core.user.User;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

public class UsersByMailCache
extends StorageCacheBase {
    private final SetMap<String, String> userNamesByMail = new SetMap();

    UsersByMailCache() {
    }

    void addUser(User user) {
        if (StringUtils.isEmpty((String)user.getEmailAddress())) {
            return;
        }
        this.userNamesByMail.add((Object)UsersByMailCache.normalize(user.getEmailAddress()), (Object)user.getUsername());
    }

    Set<String> getUsernames(String mailAddress) {
        return new HashSet<String>(this.userNamesByMail.getCollectionOrEmpty((Object)UsersByMailCache.normalize(mailAddress)));
    }

    boolean isInitialized() {
        return !this.userNamesByMail.isEmpty();
    }

    private static String normalize(String mail) {
        return mail.toLowerCase();
    }

    public synchronized void invalidateThreadSafe() {
        this.userNamesByMail.clear();
    }
}

