/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

public class SimulinkMatrix {
    private final long rows;
    private final long columns;

    public SimulinkMatrix(long rows, long columns) {
        this.rows = rows;
        this.columns = columns;
    }

    public boolean expandableTo(SimulinkMatrix target) {
        if (this.getNumberOfColumns() == target.getNumberOfColumns() && this.getNumberOfRows() == target.getNumberOfRows() || this.isScalar()) {
            return true;
        }
        if (this.isVector()) {
            long dimension = this.rows > 1L ? this.rows : this.columns;
            boolean rowsAreExpandable = true;
            if (target.getNumberOfRows() > 1L) {
                rowsAreExpandable = SimulinkMatrix.isIntegerMultiple(target.getNumberOfRows(), dimension);
            }
            boolean columnsAreExpandable = true;
            if (target.getNumberOfColumns() > 1L) {
                columnsAreExpandable = SimulinkMatrix.isIntegerMultiple(target.getNumberOfColumns(), dimension);
            }
            return rowsAreExpandable && columnsAreExpandable;
        }
        return false;
    }

    private static boolean isIntegerMultiple(long a, long b) {
        return a % b == 0L;
    }

    public long getNumberOfRows() {
        return this.rows;
    }

    public long getNumberOfColumns() {
        return this.columns;
    }

    public boolean isScalar() {
        return this.rows == -1L && this.columns == -1L;
    }

    public boolean isVector() {
        return !this.isScalar() && this.rows == -1L || this.columns == -1L;
    }

    public String toDimensionFormat() {
        if (this.isScalar()) {
            return "1";
        }
        if (this.isVector()) {
            return String.valueOf(Math.max(this.rows, this.columns));
        }
        return "[" + this.rows + " " + this.columns + "]";
    }
}

