/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.jspecify.annotations.Nullable;

public class SimulinkOutPort
extends SimulinkPortBase {
    private final Set<SimulinkLine> lines = new IdentityHashSet();

    public SimulinkOutPort(SimulinkBlock block, SimulinkPortBuilder.EPortType portType, String index, FlexiblePortPlacementParameters flexiblePortPlacementParameters) {
        super(block, portType, index, flexiblePortPlacementParameters);
        block.addOutPort(this);
    }

    void addLine(SimulinkLine line) throws IllegalArgumentException {
        CCSMAssert.isFalse((boolean)this.lines.contains(line), (String)"Line is already connected to this port.");
        CCSMAssert.isTrue((line.getSrcPort() == this ? 1 : 0) != 0, (String)"Line's port does not match.");
        this.lines.add(line);
    }

    public UnmodifiableSet<SimulinkLine> getLines() {
        return CollectionUtils.asUnmodifiable(this.lines);
    }

    public @Nullable SimulinkLine getAnyLine() {
        if (this.lines.isEmpty()) {
            return null;
        }
        return new ArrayList<SimulinkLine>(this.lines).get(0);
    }

    @Override
    public Optional<String> getSignalName() {
        if (this.lines.size() == 0) {
            return Optional.empty();
        }
        return new ArrayList<SimulinkLine>(this.lines).get(0).getName();
    }

    void removeLine(SimulinkLine line) throws IllegalArgumentException {
        CCSMAssert.isTrue((boolean)this.lines.contains(line), (String)"Line is not connected to port.");
        this.lines.remove(line);
    }

    @Override
    public void remove() {
        this.getBlock().removeOutPort(this);
        for (SimulinkLine line : new ArrayList<SimulinkLine>(this.lines)) {
            line.remove();
        }
        super.remove();
    }

    @Override
    public boolean isConnected() {
        return !this.lines.isEmpty();
    }

    public boolean isStatePort() {
        return "state".equals(this.getIndex());
    }

    @Override
    public boolean isSpecialPort() {
        return this.isStatePort();
    }
}

